package com.bxm.adscounter.rtb.common.impl.youku;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.utils.JsonHelper;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

/**
 * @author tangxiao
 * @date 2022-06-01
 * @since 1.0
 */
@Slf4j
public class YoukuRtbIntegration extends AbstractClickTrackerRtbIntegration {


    public YoukuRtbIntegration(YoukuConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.YOUKU;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "track_id";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        String ip = request.getKeyValueMap().getFirst(Inads.Param.IP);
        PositionRtb positionRtb = request.getConfig();
        MultiValueMap<String, String> queryParams = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams();
        String clickIdParameterNameOnReferrer = getClickIdParameterNameOnReferrer();
        String track_id = queryParams.getFirst(clickIdParameterNameOnReferrer);
        String creative_id = queryParams.getFirst("creative_id");
        if (StringUtils.isBlank(track_id)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }

        if (StringUtils.isBlank(creative_id)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'creative_id' by referrer.");
        }

        //String adgroup_id = queryParams.getFirst("adgroup_id");
        //appkey ：   customerId        token :  token
        Map<String, Object> param = new HashMap<>();
        param.put("event_type", eventType);
        param.put("event_time", System.currentTimeMillis());
        param.put("track_id", track_id);
        param.put("deep_conv", 0);
        param.put("client_ip", ip);
        //param.put("adgroup_id", adgroup_id);
        param.put("creative_id", creative_id);//必须是数字
        String sign = SignUtil.sign(positionRtb.getCustomerId(), positionRtb.getToken(), MapStrUtil.toStr(param));
        RequestYouku requestYouku = new RequestYouku();
        requestYouku.setAppKey(positionRtb.getCustomerId());
        requestYouku.setContent(param);
        requestYouku.setSignature(sign);
        HttpPost post = new HttpPost(url);
        post.addHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_UTF8_VALUE);
        post.setEntity(new StringEntity(JsonHelper.convert(requestYouku), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        return JsonHelper.convert(body, Response.class);
    }

    @Data
    private static class Response extends FeedbackResponse {

        //private String success;
        private String msg;
        private String msgCode;
        private String data;

        @Override
        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase("success", msg);
        }
    }

    @Data
    private static class RequestYouku {

        /**
         * 回传应用来源标识
         */
        private String appKey;

        /**
         * 签名
         */
        private String signature;

        /**
         * 内容
         */
        private Map<String, Object> content;

    }


}

