package com.bxm.adscounter.rtb.common.service;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.openlog.sdk.KeyValueMap;

/**
 * 回传服务，基于运营后台广告位的RTB配置功能。
 *
 * @author allen
 * @date 2022-05-13
 * @since 1.0
 */
public interface FeedbackService {

    /**
     * RTB实现
     * @return RTB
     */
    Rtb getRtb();

    /**
     * 执行回传处理。
     * @param keyValueMap 日志
     * @return 回传是否成功，不需要回传时也会返回 true
     * @throws RtbIntegrationException RtbIntegrationException 异常
     */
    boolean doFeedback(KeyValueMap keyValueMap) throws RtbIntegrationException;

    /**
     * 执行回传处理。
     * @param keyValueMap 日志
     * @param updating 更新器
     * @return 回传是否成功，不需要回传时也会返回 true
     * @throws RtbIntegrationException RtbIntegrationException 异常
     * @deprecated 不建议使用 updating
     */
    @Deprecated
    boolean doFeedback(KeyValueMap keyValueMap, Updating updating) throws RtbIntegrationException;
}
