package com.bxm.adscounter.rtb.common.utils;


import com.alibaba.fastjson.JSONArray;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.*;

public class PositionRTBUtils {

    /**
     * 活动参与
     */
    public static final String ACTIVITY_ATTEND = "1";

    /**
     * 活动复参
     */
    public static final String ACTIVITY_REPEAT_ATTEND = "2";

    /**
     * 广告点击
     */
    public static final String AD_CLICK = "11";

    /**
     * 广告点击，整型
     */
    public static final int AD_CLICK_INTEGER = 11;

    /**
     * 通配所有广告券
     */
    public static final String ALL_AD = "all";

    /**
     * 采用广告券的浅层或者深层行为类
     */
    public static final String AD_TYPE = "12";

    public static PositionRtb.TargetBXM convert(String ticketId, PositionRtb positionRtb) {
        //采用新的配置
        if (positionRtb.getIsUse() == 1) {
            return convertNew(ticketId, positionRtb);
        }
        return convertOld(ticketId, positionRtb);
    }

    /**
     * 判断指定广告券ID是否头部券
     * @param ticketId 广告券ID
     * @param positionRtb 配置
     * @return 在头部券组里则返回 true，其他所有情况都返回 false
     */
    public static boolean isHeadTicket(String ticketId, PositionRtb positionRtb) {
        if (positionRtb.isFeedbackModeSummaryCpa()) {
            return false;
        }
        if (positionRtb.getIsUse() == 1) {
            return isHeadTicketNew(ticketId, positionRtb);
        } else {
            return isHeadTicketOld(ticketId, positionRtb);
        }
    }

    private static boolean isHeadTicketOld(String ticketId, PositionRtb positionRtb) {
        List<PositionRtb.TargetBXM> headTicketList = JSONArray.parseArray(positionRtb.getHeadTicketJson(), PositionRtb.TargetBXM.class);
        Optional<PositionRtb.TargetBXM> find = headTicketList.stream().filter(e -> {
            return Sets.newHashSet(StringUtils.split(e.getTicketIds(), ",")).contains(ticketId);
        }).findFirst();
        return find.isPresent();
    }

    private static boolean isHeadTicketNew(String ticketId, PositionRtb positionRtb) {
        List<PositionRtb.PositionRtbHeadTicketGroup> newHeadList = positionRtb.getNewHeadList();
        for (PositionRtb.PositionRtbHeadTicketGroup group : newHeadList) {
            List<PositionRtb.TargetBXM> headTicketList = group.getHeadTicketList();
            Optional<PositionRtb.TargetBXM> find = headTicketList.stream().filter(e -> {
                return Sets.newHashSet(StringUtils.split(e.getTicketIds(), ",")).contains(ticketId);
            }).findFirst();
            if (find.isPresent()) {
                return true;
            }
        }
        return false;
    }

    public static PositionRtb.TargetBXM convertOld(String ticketId, PositionRtb positionRtb) {
        //代表了配置了RTB
        Map<String, PositionRtb.TargetBXM> map = new HashMap<>();
        //开始查找可以传效果监控的券
        List<PositionRtb.TargetBXM> headList = JSONArray.parseArray(positionRtb.getHeadTicketJson(), PositionRtb.TargetBXM.class);
        List<PositionRtb.TargetBXM> helpList = new ArrayList<>();
        if (StringUtils.isNotBlank(positionRtb.getHelpTicketJson())) {
            helpList = JSONArray.parseArray(positionRtb.getHelpTicketJson(), PositionRtb.TargetBXM.class);
        }
        if (CollectionUtils.isNotEmpty(helpList)) {
            headList.addAll(helpList);
        }
        for (PositionRtb.TargetBXM result : headList) {
            Arrays.asList(result.getTicketIds().split(",")).forEach(id -> {
                map.put(id, result);
            });
        }
        PositionRtb.TargetBXM targetBXM = map.get(ticketId);
        //判断是否有通投配置
        if(Objects.isNull(targetBXM)){
            targetBXM = map.get(ALL_AD);
        }

        return targetBXM;
    }

    public static PositionRtb.TargetBXM convertNew(String ticketId, PositionRtb positionRtb) {
        //代表了配置了RTB
        Map<String, PositionRtb.TargetBXM> map = new HashMap<>();
        List<PositionRtb.PositionRtbHeadTicketGroup> newHeadList = positionRtb.getNewHeadList();
        List<PositionRtb.TargetBXM> headList = new ArrayList<>();
        List<PositionRtb.TargetBXM> helpList = new ArrayList<>();

        if (StringUtils.isNotBlank(positionRtb.getHelpTicketJson())) {
            helpList = JSONArray.parseArray(positionRtb.getHelpTicketJson(), PositionRtb.TargetBXM.class);
        }
        if (CollectionUtils.isNotEmpty(helpList)) {
            headList.addAll(helpList);
        }

        for (PositionRtb.PositionRtbHeadTicketGroup result : newHeadList) {
            List<PositionRtb.TargetBXM> childHeadList = result.getHeadTicketList();
            headList.addAll(childHeadList);
        }

        for (PositionRtb.TargetBXM result : headList) {
            Arrays.asList(result.getTicketIds().split(",")).forEach(id -> {
                map.put(id, result);
            });
        }
        PositionRtb.TargetBXM targetBXM = map.get(ticketId);
        //判断是否有通投配置
        if(Objects.isNull(targetBXM)){
            targetBXM = map.get(ALL_AD);
        }
        return targetBXM;
    }

    public static KeyGenerator stringActivityAttend(String uid) {
        return () -> KeyBuilder.build("ACTIVITY", "JOIN", "COUNT", uid);
    }


    public static boolean isAdClick(Integer type) {
        return Objects.equals(type, AD_CLICK_INTEGER);
    }
}
