//package com.bxm.adscounter.temp.scheduler;
//
//import com.bxm.adscounter.rtb.common.RtbIntegrationException;
//import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
//import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
//import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouConfig;
//import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouRtbIntegration;
//import com.bxm.warcar.utils.JsonHelper;
//import com.google.common.collect.Lists;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.io.FileUtils;
//import org.apache.commons.io.IOUtils;
//import org.springframework.boot.context.event.ApplicationStartedEvent;
//import org.springframework.context.ApplicationListener;
//import org.springframework.context.annotation.Configuration;
//import org.springframework.core.io.ClassPathResource;
//
//import java.io.File;
//import java.io.IOException;
//import java.io.InputStream;
//import java.nio.charset.StandardCharsets;
//import java.util.List;
//import java.util.concurrent.TimeUnit;
//
///**
// * @author allen
// * @date 2022-06-28
// * @since 1.0
// */
//@Slf4j
////@Configuration
//public class FeedbackScheduler implements ApplicationListener<ApplicationStartedEvent> {
//
//    @Override
//    public void onApplicationEvent(ApplicationStartedEvent event) {
//        try {
//            start();
//        } catch (IOException e) {
//            log.error("start: ", e);
//            System.exit(-1);
//        }
//    }
//
//    private void start() throws IOException {
//        KuaishouRtbIntegration integration = new KuaishouRtbIntegration(new KuaishouConfig());
//
//        String source = "callback.txt";
//        String finish = source + ".fis";
//        ClassPathResource resource = new ClassPathResource(source);
//        File file = resource.getFile();
//        File dest = new File(file.getParent() + File.separator + finish);
//        if (!dest.exists()) {
//            log.info("create new file: {}", dest);
//            if (!dest.createNewFile()) {
//                throw new IOException(String.format("createNewFile %s fail.", dest.getPath()));
//            }
//        }
//        String path = file.getPath();
//        log.info("Starting process file: {}", path);
//        InputStream inputStream = resource.getInputStream();
//        List<String> lines = IOUtils.readLines(inputStream, StandardCharsets.UTF_8);
//        log.info("Size: {}", lines.size());
//        List<String> finished = FileUtils.readLines(dest, StandardCharsets.UTF_8);
//        lines.forEach(id -> {
//            if (finished.contains(id)) {
//                log.info("ignore: {}", id);
//                return;
//            }
//
//            try {
//                FileUtils.writeLines(dest, Lists.newArrayList(id), true);
//            } catch (IOException e) {
//                log.error("writeLines: {}", e.getMessage());
//            }
//
//            try {
//                FeedbackResponse response = integration.doFeedback(FeedbackRequest.builder()
//                        .eventType("3")
//                        .referrer("https://tmp.hzbxm.com/action?callback=" + id)
//                        .build());
//                log.info("{} - {}", id, JsonHelper.convert(response));
//
//                TimeUnit.SECONDS.sleep(100);
//            } catch (RtbIntegrationException | InterruptedException e) {
//                log.error("doFeedback: {}", e.getMessage());
//            }
//        });
//        log.info("Completed!");
//    }
//}
