package com.bxm.adscounter.temp.scheduler;

import com.bxm.openlog.extension.client.Fallback;
import com.bxm.warcar.id.random.RandomIdGenerator;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UUIDHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHeaders;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

/**
 * @author allen
 * @date 2022-07-18
 * @since 1.0
 */
@Slf4j
@Configuration
public class SimConversionController implements ApplicationListener<ApplicationStartedEvent> {

    private final AtomicLong countKsClick = new AtomicLong();
    private final AtomicLong countIndexShow = new AtomicLong();
    private final AtomicLong countActivityAttend = new AtomicLong();
    private final AtomicLong countAdClick = new AtomicLong();
    private final AtomicLong countAdConv = new AtomicLong();

    private final TempProperties properties;

    public SimConversionController(TempProperties properties) {
        this.properties = properties;
        log.info("当前配置：\n{}", JsonHelper.convert(properties));
    }

    @Override
    public void onApplicationEvent(ApplicationStartedEvent event) {
        try {
            doExecute();
        } catch (Exception e) {
            log.error("", e);
        }
    }

    private void doExecute() {
        MyOpenLogClient client = MyOpenLogClient.builder().build();

        final String tagid = properties.getTagId();
        final String adid = properties.getAdId();
        final String aid = properties.getAid();
        final String conversionType = properties.getConversionType();
        final String ua = properties.getUa();

        final Map<String, String> headers = Maps.newHashMap();
        headers.put(HttpHeaders.USER_AGENT, ua);

        RandomIdGenerator id = new RandomIdGenerator();

        Queue<String> clickIdQueue = new LinkedBlockingQueue<>();
        Queue<String> enterClickIdQueue = new LinkedBlockingQueue<>();
        Queue<String> bxmIdQueue = new LinkedBlockingQueue<>();

        final int oneMinute = 60 * 1000;

        // 模拟快手点击监测
        new Thread(() -> {
            while (true) {
                String url = "http://47.98.242.33:8090/common/s.gif?mt=30" +
                        "&tagid=__TAGID__" +
                        "&rtb_id=1" +
                        "&ad_group_id=__AID__" +
                        "&click_id=http%3a%2f%2fad.partner.gifshow.com%2ftrack%2factivate%3fcallback%3d__CALLBACK__" +
                        "&accountid=__ACCOUNTID__&cid=__CID__&did=__DID__&imei2=__IMEI2__&imei3=__IMEI3__&oaid=__OAID__&oaid2=__OAID2__&idfa2=__IDFA2__&idfa3=__IDFA3__&androidid2=__ANDROIDID2__&androidid3=__ANDROIDID3__";
                String clickId = UUIDHelper.generate();
                url = url
                        .replaceAll("__TAGID__", tagid)
                        .replaceAll("__CALLBACK__", clickId)
                        .replaceAll("__AID__", aid)
                        .replaceAll("__IMEI3__", UUIDHelper.generate());
                clickIdQueue.add(clickId);
                client.asyncRequest2(url, headers, null);
                log.info("模拟RTB点击监测第 {} 次：{}", countKsClick.incrementAndGet(), clickId);
                try {
                    Thread.sleep(oneMinute / properties.getClickTrackerInMin());
                } catch (InterruptedException ignored) {
                }
            }
        }).start();

        // 模拟参与活动
        if (properties.isEnableActivityAttend()) {
            new Thread(new Runnable() {
                @Override
                public void run() {
                    while (true) {
                        String clickId = clickIdQueue.poll();

                        if (StringUtils.isBlank(clickId)) {
                            try {
                                Thread.sleep(1000);
                            } catch (InterruptedException ignored) {
                            }
                            continue;
                        }

                        enterClickIdQueue.add(clickId);

                        doIndexShow(clickId);
                        doActivityAttend(clickId);

                        try {
                            Thread.sleep(oneMinute / properties.getActivityAttendInMin());
                        } catch (InterruptedException ignored) {
                        }
                    }
                }

                private void doIndexShow(String clickId) {
                    String url = "http://47.98.242.33:8090/inads/s.gif?mt=9" +
                            "&uid=931093120&tagid=__TAGID__&os=1&spm=20220402105224378000013715553420&activityid=12909&scene=0&x=0&y=0&wh=412,914&popupid=0&createid=40065&fm_model_id=DINCalibration-CVR1OCPC-CVRAssets" +
                            "&ip=61.130.182.194" +
                            "&ext=__EXT__";

                    Map<String, String> rtbParams = new HashMap<>();
                    rtbParams.put("callback", clickId);

                    url = url
                            .replaceAll("__TAGID__", tagid)
                            .replaceAll("__EXT__", UrlHelper.urlEncode(JsonHelper.convert(rtbParams)));

                    client.asyncRequest2(url, headers, null);
                    log.info("模拟进入中间页第 {} 次：{}", countIndexShow.incrementAndGet(), clickId);
                }

                private void doActivityAttend(String clickId) {
                    String url = "http://47.98.242.33:8090/inads/s.gif?mt=4" +
                            "&uid=931093120&tagid=__TAGID__&os=1&spm=20220402105224378000013715553420&activityid=12909&scene=0&x=0&y=0&wh=412,914&popupid=0&createid=40065&fm_model_id=DINCalibration-CVR1OCPC-CVRAssets" +
                            "&refer=https%3A%2F%2Fm.cat-happy.cn%2Fdist%2FwelfareAT02%2Fprivate%2FT%2FT089%2Findex.html%3Fbusiness%3Dmoney-9%26appkey%3D45cc2d9c0d144632b96f7a231e48117f%26uid%3D931093120%26activityid%3D12909%26spm%3D20220402105224378000013715553420%26callback%3D__CALLBACK__" +
                            "&ip=61.130.182.194";

                    url = url
                            .replaceAll("__TAGID__", tagid)
                            .replaceAll("__CALLBACK__", clickId);

                    client.asyncRequest2(url, headers, null);
                    log.info("模拟参与活动第 {} 次：{}", countActivityAttend.incrementAndGet(), clickId);
                }
            }).start();
        }

        // 模拟互动广告点击
        if (properties.isEnableAdClick()) {
            new Thread(() -> {
                while (true) {
                    String url = "http://47.98.242.33:8090/inads/s.gif?mt=7" +
                            "&bxmid=__BXMID__&adid=__ADID__&uid=931093120&tagid=__TAGID__&os=1&spm=20220402105224378000013715553420&activityid=12909&scene=0&x=0&y=0&wh=412,914&popupid=0&createid=40065&fm_model_id=DINCalibration-CVR1OCPC-CVRAssets" +
                            "&refer=https%3A%2F%2Fm.cat-happy.cn%2Fdist%2FwelfareAT02%2Fprivate%2FT%2FT089%2Findex.html%3Fbusiness%3Dmoney-9%26appkey%3D45cc2d9c0d144632b96f7a231e48117f%26uid%3D931093120%26activityid%3D12909%26spm%3D20220402105224378000013715553420%26callback%3D__CALLBACK__" +
                            "&ip=61.130.182.194";

                    String clickId = enterClickIdQueue.poll();

                    if (StringUtils.isBlank(clickId)) {
                        try {
                            Thread.sleep(1000);
                        } catch (InterruptedException ignored) {
                        }
                        continue;
                    }
                    String bxmId = id.next();

                    bxmIdQueue.add(bxmId);

                    url = url
                            .replaceAll("__ADID__", adid)
                            .replaceAll("__TAGID__", tagid)
                            .replaceAll("__CALLBACK__", clickId)
                            .replaceAll("__BXMID__", bxmId);

                    client.asyncRequest2(url, headers, null);
                    log.info("模拟广告点击第 {} 次：{}", countAdClick.incrementAndGet(), bxmId);
                    try {
                        Thread.sleep(oneMinute / properties.getAdClickInMin());
                    } catch (InterruptedException ignored) {
                    }
                }
            }).start();
        }

        // 模拟有效点击
        if (properties.isEnableAdConversion()) {
            new Thread(() -> {
                while (true) {
                    String url = "http://47.98.242.33:8090/inads/s.gif?mt=8&bxmid=__BXMID__&conversion_type=__CONVERSION_TYPE__";
                    String bxmId = bxmIdQueue.poll();
                    if (StringUtils.isBlank(bxmId)) {
                        try {
                            Thread.sleep(1000);
                        } catch (InterruptedException ignored) {
                        }
                        continue;
                    }
                    url = url
                            .replaceAll("__BXMID__", bxmId)
                            .replaceAll("__CONVERSION_TYPE__", conversionType);

                    long convTime = countAdConv.incrementAndGet();
                    client.asyncRequest2(url, headers, new Consumer<Fallback>() {
                        @Override
                        public void accept(Fallback fallback) {
                            log.error("模拟广告转化第 {} 次失败了：{}", convTime, Optional.ofNullable(fallback.getException()).map(Exception::getMessage).orElse("?"));
                        }
                    });
                    log.info("模拟广告转化第 {} 次：{}", convTime, url);
                    try {
                        Thread.sleep(oneMinute / properties.getAdConversionInMin());
                    } catch (InterruptedException ignored) {
                    }
                }
            }).start();
        }
    }
}
