package com.bxm.adscounter.temp.scheduler;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author allen
 * @date 2022-07-18
 * @since 1.0
 */
@Data
@ConfigurationProperties(prefix = "application")
public class TempProperties {

    private String tagId;
    private String adId;
    private String aid;
    private String conversionType;
    private String ua;
    private boolean enableActivityAttend = false;
    private boolean enableAdClick = false;
    private boolean enableAdConversion = false;
    private int clickTrackerInMin = 60;
    private int activityAttendInMin = 60;
    private int adClickInMin = 60;
    private int adConversionInMin = 10;
}
