/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.facade.model.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;

public class Money
implements Serializable,
Comparable<Money> {
    private static final long serialVersionUID = 7013286615982402339L;
    private long li;
    private RoundingMode roundingMode = RoundingMode.HALF_UP;
    public static final Money ZERO = Money.ofLi(0L);

    private Money() {
    }

    public static Money ofLi(long li) {
        Money money = new Money();
        money.setLi(li);
        return money;
    }

    public static Money ofCent(long cent) {
        Money money = new Money();
        money.setLi(Money.convertCentToLi(cent));
        return money;
    }

    public static Money ofYuan(double yuan) {
        return Money.ofYuan(yuan, RoundingMode.HALF_UP);
    }

    public static Money ofYuan(double yuan, RoundingMode roundingMode) {
        Money money = new Money();
        money.setLi(Money.convertYuanToLi(yuan, roundingMode));
        return money;
    }

    public Money withRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
        return this;
    }

    public long getLi() {
        return this.li;
    }

    public long getCent() {
        return BigDecimal.valueOf(this.getLi()).movePointLeft(1).setScale(0, this.roundingMode).longValue();
    }

    public double getYuan() {
        return BigDecimal.valueOf(this.getLi()).movePointLeft(3).setScale(3, this.roundingMode).doubleValue();
    }

    public static Money total(Money ... monies) {
        if (monies.length == 0) {
            throw new IllegalArgumentException("Money array must not be empty");
        }
        return Money.total(Lists.newArrayList((Object[])monies));
    }

    public static Money total(Iterable<? extends Money> monies) {
        Preconditions.checkNotNull(monies, (Object)"Money iterator must not be null");
        Iterator<? extends Money> it = monies.iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Money iterator must not be empty");
        }
        Money total = it.next();
        Preconditions.checkNotNull((Object)total, (Object)"Money iterator must not contain null entries");
        while (it.hasNext()) {
            total = total.plus(it.next());
        }
        return total;
    }

    public Money plus(Money money) {
        Preconditions.checkNotNull((Object)money, (Object)"money must not be null");
        return this.plus(money.getLi());
    }

    public Money plus(long li) {
        this.setLi(this.getLi() + li);
        return this;
    }

    public Money plusCent(long cent) {
        if (cent == 0L) {
            return this;
        }
        this.plus(Money.convertCentToLi(cent));
        return this;
    }

    public Money plusYuan(double yuan) {
        if (yuan == 0.0) {
            return this;
        }
        this.plus(Money.convertYuanToLi(yuan, this.roundingMode));
        return this;
    }

    public Money minus(Money money) {
        Preconditions.checkNotNull((Object)money, (Object)"money must not be null");
        return this.minus(money.getLi());
    }

    public Money minus(long li) {
        if (li == 0L) {
            return this;
        }
        this.setLi(this.getLi() - li);
        return this;
    }

    public Money minusCent(long cent) {
        if (cent == 0L) {
            return this;
        }
        this.setLi(this.getLi() - Money.convertCentToLi(cent));
        return this;
    }

    public Money minusYuan(double yuan) {
        if (yuan == 0.0) {
            return this;
        }
        this.setLi(this.getLi() - Money.convertYuanToLi(yuan, this.roundingMode));
        return this;
    }

    public Money multipliedBy(long valueToMultiplyBy) {
        if (valueToMultiplyBy == 1L) {
            return this;
        }
        this.setLi(this.getLi() * valueToMultiplyBy);
        return this;
    }

    public Money multipliedBy(double valueToMultiplyBy) {
        return this.multipliedBy(valueToMultiplyBy, this.roundingMode);
    }

    public Money multipliedBy(double valueToMultiplyBy, RoundingMode roundingMode) {
        if (valueToMultiplyBy == 1.0) {
            return this;
        }
        BigDecimal amountLiBig = BigDecimal.valueOf(this.getLi());
        BigDecimal valueToMultiplyByBig = BigDecimal.valueOf(valueToMultiplyBy);
        BigDecimal result = amountLiBig.multiply(valueToMultiplyByBig).setScale(0, roundingMode);
        this.setLi(result.longValue());
        return this;
    }

    public boolean isNegative() {
        return this.getLi() < 0L;
    }

    public boolean isNegativeOrZero() {
        return this.getLi() <= 0L;
    }

    public boolean isEqual(Money other) {
        return this.compareTo(other) == 0;
    }

    public boolean isGreaterThan(Money other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLessThan(Money other) {
        return this.compareTo(other) < 0;
    }

    private static long convertYuanToLi(double yuan, RoundingMode roundingMode) {
        return BigDecimal.valueOf(yuan).movePointRight(3).setScale(0, roundingMode).longValue();
    }

    private static long convertCentToLi(long cent) {
        return cent * 10L;
    }

    private void setLi(long li) {
        this.li = li;
    }

    public int hashCode() {
        return Longs.hashCode((long)this.getLi());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Money) {
            Money otherMoney = (Money)other;
            return this.getLi() == otherMoney.getLi();
        }
        return false;
    }

    @Override
    public int compareTo(Money otherMoney) {
        if (otherMoney == null) {
            return 1;
        }
        return Longs.compare((long)this.getLi(), (long)otherMoney.getLi());
    }

    public String toString() {
        return this.getLi() + " li";
    }
}

