package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.ticket.AdAssets;
import com.bxm.adsmanager.facade.model.ticket.AdTicketDto;
import com.bxm.adsmanager.facade.model.ticket.AdTicketVo;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author wangchao
 * @description 广告主券相关接口
 * @date 2019/04/09 16:48
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdvertiserTicketFacadeService {

    @RequestMapping(value = "/advertiser/updateAdTicket", method = RequestMethod.POST)
    ResultModel update(@RequestParam(required = true, name = "id") Long id,
                       @RequestParam(required = true, name = "status") Short status);


    @RequestMapping(value = "/advertiser/updateDailyBudget", method = RequestMethod.POST)
    ResultModel update(@RequestParam(required = true, name = "id") Long id,
                       @RequestParam(required = true, name = "dailyBudget") Double dailyBudget);


    @RequestMapping(value = "/advertiser/getAdvertiserBalance", method = RequestMethod.GET)
    ResultModel getAdvertiserBalance(@RequestParam(required = true, name = "id") Long id);


    @RequestMapping(value = "/advertiser/reUpdateAdTicket", method = RequestMethod.POST)
    ResultModel reUpdate(@RequestParam(required = true, name = "id") Long id,
                         @RequestParam(required = true, name = "status") Short status);


    @RequestMapping(value = "/advertiser/findBalanceByIds", method = RequestMethod.POST)
    ResultModel findBalanceByIds(@RequestParam(value = "advertiserIds") List<Integer> advertiserIds);

    /*以下是新接口*/

    @RequestMapping(value = "/advertiser/addAdAssets", method = RequestMethod.POST)
    ResultModel<Long> addAssets(@RequestBody AdAssets adAssets);

    @RequestMapping(value = "/advertiser/updateAdAssets", method = RequestMethod.POST)
    ResultModel<String> updateAssets(@RequestBody AdAssets adAssets);


    @RequestMapping(value = "/advertiser/queryAdvertiserByParam", method = RequestMethod.GET)
    ResultModel<Long> queryAdvertiserByParam(@RequestParam(required = false, name = "adAssetId") Long adAssetId,
                                             @RequestParam(required = false, name = "ticketId") Long ticketId);


    @RequestMapping(value = "/advertiser/delAdAssets", method = RequestMethod.DELETE)
    ResultModel<Boolean> deleteAssets(@RequestParam(required = true, name = "id") String id);


    @RequestMapping(value = "/advertiser/findAllAssets", method = RequestMethod.GET)
    ResultModel<List<AdAssets>> findAllAssets(@RequestParam(required = true, name = "ids") String ids);

    @RequestMapping(value = "/advertiser/findAllAssetsByTicketId", method = RequestMethod.GET)
    ResultModel<List<AdAssets>> findAllAssetsByTicketId(@RequestParam(required = true, name = "ticketId") Long ticketId);


    @RequestMapping(value = "/advertiser/addTicket", method = RequestMethod.POST, produces = "application/json")
    ResultModel<Long> addTicket(@RequestBody AdTicketDto adTicketDto);

    @RequestMapping(value = "/advertiser/updateTicket", method = RequestMethod.POST, produces = "application/json")
    ResultModel<Boolean> updateTicket(@RequestBody AdTicketDto adTicketDto);

    @RequestMapping(value = "/advertiser/getTicketById", method = RequestMethod.GET)
    ResultModel<AdTicketVo> find(@RequestParam(required = true, name = "id") Long id);
}
