package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.precharge.PrechargeRecordVo;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author tangx
 * @date 2020/5/14 16:37
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface PrechargeFacadeService {

    @RequestMapping("/facade/precharge/config/list")
    ResultModel listPrechargeConfig(@RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                    @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize,
                                    @RequestParam("account") String account);


    @RequestMapping("/facade/precharge/rechargeDetail/list")
    ResultModel<PageInfo<PrechargeRecordVo>> listRechargeDetail(@RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize,
                                                                @RequestParam("startTime") String startTime,
                                                                @RequestParam("endTime") String endTime,
                                                                @RequestParam("accountId") Long accountId);

    @RequestMapping("/facade/precharge/rechargeBalance")
    Boolean rechargeBalance(@RequestParam("accountId") Long accountId,
                            @RequestParam("amount") BigDecimal amount,
                            @RequestParam(value = "currentUser", required = false) String currentUser);

}
