package com.bxm.adsmanager.facade.model.ticket;

import com.bxm.adsmanager.facade.model.base.Money;

import java.io.Serializable;

/**
 * 优化广告流量包功能
 */
public class AdFlowPackageNewVo implements Serializable {

    private static final long serialVersionUID = 4277320240426350491L;
    /**
     * 关联 ID
     */
    private Long id;
    /**
     * 流量包 ID
     */
    private Long flowPackageId;
    /**
     * 流量包名称
     */
    private String packageName;
    /**
     * 广告位数量
     */
    private Integer count;
    /**
     * 今日消耗
     */
    private String consume;
    /**
     * 出价
     */
    private Long price;
    private Double priceYuan;
    /**
     * 限额
     */
    private String quota;
    /**
     * 广告券id
     */
    private Long ticketId;
    /**
     * 1,流量包分配黑白名单|2，流量包分配出价和限额
     */
    private Integer type;

    public Long getFlowPackageId() {
        return flowPackageId;
    }

    public void setFlowPackageId(Long flowPackageId) {
        this.flowPackageId = flowPackageId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPackageName() {
        return packageName;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public String getConsume() {
        return consume;
    }

    public void setConsume(String consume) {
        this.consume = consume;
    }

    public String getQuota() {
        return quota;
    }

    public Double getPriceYuan() {
        if (price != null) {
            Money money = Money.ofLi(price);
            return money.getYuan();
        }
        return priceYuan;
    }

    public void setPriceYuan(Double priceYuan) {
        this.priceYuan = priceYuan;
    }

    public void setQuota(String quota) {
        this.quota = quota;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

}
