/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adsmanager.facade.model.base;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.springframework.format.annotation.DateTimeFormat;

import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;

public class CommonDto implements Serializable {

    private static final long serialVersionUID = 1311513612985526019L;
    /**
     * 页码
     */
    private Integer pageNum = 1;
    /**
     * 每页数量
     */
    private Integer pageSize = 10;
    /**
     * 排序参数
     */
    private String orderParam;
    /**
     * 排序方式：asc/desc
     */
    private String orderType;
    /**
     * id
     */
    private Integer id;
    /**
     * ids
     */
    private List<Integer> ids;
    /**
     * 查询关键字
     */
    private String keywords;
    /**
     * 查询开始时间
     */
    @DateTimeFormat(pattern = LocalDateTimeHelper.PATTERN_STR10)
    private Date startTime;
    /**
     * 查询结束时间
     */
    @DateTimeFormat(pattern = LocalDateTimeHelper.PATTERN_STR10)
    private Date endTime;

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderParam() {
        return orderParam;
    }

    public void setOrderParam(String orderParam) {
        this.orderParam = orderParam;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public List<Integer> getIds() {
        return ids;
    }

    public void setIds(List<Integer> ids) {
        this.ids = ids;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {

        this.startTime = startTime == null ? increaseDate(new Date(), -14) : startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime == null ? new Date() : increaseDate(endTime, 1);
    }

    public static Date increaseDate(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.DAY_OF_MONTH, days);
        return cal.getTime();
    }

}
