package com.bxm.adsmanager.facade.model.position;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * @author tangx
 * @date 2022/11/15 19:09
 */
@Data
public class PositionUpdateDto {
    @NotBlank
    private String appKey;

    /**
     * 开发者别名
     */
    @NotBlank
    private String appName;

    private String BD;

    private String MJ;

    private String remark;

    /**
     * 是否预付
     */
    @NotNull
    private Boolean prepay;

    /**
     * 账号类型 0直客， 1代理
     */
    @NotNull
    private Byte accountType;

    private Byte rtbType;

    private Byte allowOcpr;

    private String dataViewingRole;

    private String domain;

    private String intro;

    private String actRule;

    private String actExplain;

    private Byte activityStatement;

    private String wbAppId;

    private String modifier;

    /**
     * 快手appId
     */
    private String kuaishouAppId;

    /**
     * 快手密钥
     */
    private String kuaishouSecret;

}
