package com.bxm.adsmanager.facade.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.warcar.utils.response.ResultModel;

/**
 * 素材模板
 *
 * @author zhengwangeng
 * @since 2022-02-09
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdAssetsTemplateFacadeService {

    /**
     * 根据名称获得ID
     * @param name
     * @return
     */
    @RequestMapping(value = "/adsmanager/adAssetsTemplate/findIdByName", method = RequestMethod.GET)
    public ResultModel<Long> findIdByName(@RequestParam(required = true, name = "name" ) String name);

    /**
     * 保存
     * @param json
     * @return
     */
    @RequestMapping(value = "/adsmanager/adAssetsTemplate/add", method = RequestMethod.POST)
    ResultModel<Long> add(@RequestBody String json);
}
