package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.diysite.SiteInstanceDto;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author wangchao
 * @description 广告主自建站相关接口
 * @date 2019/04/09 11:07
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdvertiserDIYSiteFacadeService {

    @RequestMapping("/advertiser/diysite/getTemplates")
    ResultModel getTemplates(@RequestBody SiteInstanceDto dto);

    @RequestMapping("/advertiser/diysite/findAll")
    ResultModel findAll(@RequestBody SiteInstanceDto dto);


    @RequestMapping(value = "/advertiser/diysite/add", produces = "application/json")
    ResultModel add(@RequestBody SiteInstanceDto dto);


    @RequestMapping(value = "/advertiser/diysite/update", produces = "application/json")
    ResultModel update(@RequestBody SiteInstanceDto dto);

    @RequestMapping("/advertiser/diysite/get")
    ResultModel get(@RequestBody SiteInstanceDto dto);

}
