package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.qualify.TblAdQualify;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author wangchao
 * @description 广告主资质相关
 * @date 2019/04/09 11:08
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdvertiserQualifyFacadeService {

    @RequestMapping(value = "/advertiser/qualify", method = RequestMethod.POST)
    ResultModel<Boolean> addQualify(@RequestBody String json);

    @RequestMapping(value = "/advertiser/qualifyById", method = RequestMethod.GET)
    ResultModel<TblAdQualify> getQualifyById(@RequestParam(name = "id", required = true) Integer id);

    @RequestMapping(value = "/advertiser/updateQualify", method = RequestMethod.POST)
    ResultModel<Boolean> updateQualifyById(@RequestBody TblAdQualify record);

    @RequestMapping(value = "/advertiser/getQualifyList", method = RequestMethod.GET)
    ResultModel<PageInfo<TblAdQualify>> getQualifyList(
            @RequestParam(name = "auditStatus", required = false) Integer auditStatus,
            @RequestParam(value = "advertiserIds", required = false) List<Long> advertiserIds);
}
