package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.precharge.PrechargeCorrectSearchDTO;
import com.bxm.adsmanager.facade.model.precharge.PrechargeDTO;
import com.bxm.adsmanager.facade.model.precharge.PrechargeRecordVo;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * @author tangx
 * @date 2020/5/14 16:37
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface PrechargeFacadeService {

    @RequestMapping("/facade/precharge/config/list")
    ResultModel listPrechargeConfig(@RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                    @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize,
                                    @RequestParam("account") String account,
                                    @RequestParam("providerKeyword") String providerKeyword,
                                    @RequestParam("dateTime") String dateTime,
                                    @RequestParam(value = "mjs",required = false) String mjs,
                                    @RequestParam(value = "bds",required = false) String bds,
                                    @RequestParam(value = "areaType", required = false, defaultValue = "0") Integer areaType);


    @RequestMapping("/facade/precharge/rechargeDetail/list")
    ResultModel<PageInfo<PrechargeRecordVo>> listRechargeDetail(@RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize,
                                                                @RequestParam("startTime") String startTime,
                                                                @RequestParam("endTime") String endTime,
                                                                @RequestParam("accountId") Long accountId);

    @RequestMapping("/facade/precharge/rechargeBalance")
    Boolean rechargeBalance(@RequestParam("accountId") Long accountId,
                            @RequestParam("amount") BigDecimal amount,
                            @RequestParam("datetime") String datetime,
                            @RequestParam(value = "currentUser", required = false) String currentUser);

    @RequestMapping("/facade/precharge/correct/list")
    PageInfo getCorrectRecordList(@RequestBody PrechargeCorrectSearchDTO dto);

    @RequestMapping("/facade/precharge/correct/audit")
    Boolean correctAudit(@RequestParam("correctId") Long correctId,
                         @RequestParam("auditStatus") Byte auditStatus,
                         @RequestParam(value = "refuseReason", required = false) String refuseReason,
                         @RequestParam("auditUser") String auditUser);

    @RequestMapping("/facade/precharge/updateProviderEndDate")
    ResultModel<Boolean> updateProviderEndDate(@RequestParam("accountId") Long accountId, @RequestParam("providers") String providers);

    @RequestMapping("/facade/precharge/config/add")
    ResultModel addPrechargeConfig(@RequestBody PrechargeDTO dto);

    @RequestMapping("/facade/precharge/config/update")
    ResultModel updatePrechargeConfig(@RequestBody PrechargeDTO dto);

}
