package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.position.TicketPositionIncomeVO;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author jingyu.li
 * @date 2023-01-03
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface TicketIncomePositionFacadeService {

    /**
     * 根据广告位的id查询广告位的消耗
     * @param ticketPositionIncomeVO
     * @return
     */
    @PostMapping(value = "/facade/TicketPosition/income", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel<List<TicketPositionIncomeVO>> getPositionIncome(@RequestBody TicketPositionIncomeVO ticketPositionIncomeVO);
}
