package com.bxm.adsmedia.web.controller;

import com.bxm.adsmedia.common.util.DateUtil;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceMinOnlineTimeByAppKeyVO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceByMinOnlineTimeParamDTO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.adsmedia.service.common.MailService;
import com.bxm.adsmedia.service.media.facade.FacadeAppEntranceService;
import com.bxm.adsmedia.service.provider.facade.FacadeProviderService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;


/**
 * Description 开发者
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/15 10:08
 */

@Slf4j
@RestController
@RequestMapping("/test")
public class TestController {

    @Autowired
    private FacadeProviderService facadeProviderService;
    @Autowired
    private FacadeAppEntranceService facadeAppEntranceService;
    @Autowired
    private MailService mailService;


    @RequestMapping(value = "/test")
    public ResultModel<List<AppEntranceMinOnlineTimeByAppKeyVO>> getAppEntranceMinOnlineTimeGroupByAppKey(QueryAppEntranceByMinOnlineTimeParamDTO paramDTO) {
        List<String> appKeys = new ArrayList<>();
        appKeys.add("a0b11e41e15041929219fc56dcffc597");
        appKeys.add("2836d8095b5d431bab3b1a48e881d205");
        appKeys.add("d3e539ff67104565ab7a27d1face582e");
        appKeys.add("965b520a96f643dfbedec5f336b2eded");
        appKeys.add("0070d64024fc49cbaa6593350e8ae3ba");
        appKeys.add("95b9f00ac99d4562be2a8051548837bd");
        appKeys.add("30b3a2cb67874d5b850a0b69088ffdb3");
        appKeys.add("8eab40acf26247bdb61287577b29d9a4");
        appKeys.add("116b75d1682044bca95cf6bd65d22a75");
        appKeys.add("d229c559c27245fc94dbcaa2e7d64b61");
        paramDTO.setAppKeys(appKeys);
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.getAppEntranceMinOnlineTimeGroupByAppKey(paramDTO));
    }

    @RequestMapping(value = "/test1")
    public ResultModel<List<AppEntranceAdRO>> getList(QueryAppEntranceParamDTO dto) {
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.getPageInFacade(dto).getList());

    }

    @RequestMapping(value = "/test2")
    public ResultModel<PageInfo<AppEntranceAdRO>> getPage(QueryAppEntranceParamDTO dto) {
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.getPageInFacade(dto));
    }

    @RequestMapping(value = "/mail")
    public ResultModel mail() {
        String today = DateUtil.dateToFormat(new Date(), "yyyy-MM-dd HH:mm:ss");
        Map<String, Object> valueMap = new HashMap<>();
        valueMap.put("ask_datetime", today);
        valueMap.put("receiver_name", "测试邮件");
        valueMap.put("login_links", "http://www.bianxianmao.com");
        valueMap.put("play_links", "http://www.bianxianmao.com");
        List<String> toList = new ArrayList<>();
        toList.add("jiangyuanjun@bianxianmao.com");
        try {
            mailService.sendRegisterAuditSuccess(toList, "变现猫-媒体信息审核通过！", valueMap);
            return ResultModelFactory.SUCCESS();
        }catch (Exception e){
            return ResultModelFactory.FAILED500(ExceptionUtils.getStackTrace(e));
        }
    }
}
