package com.bxm.adsmedia.web.controller.article;

import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.adsmedia.model.vo.article.ArticleVO;
import com.bxm.adsmedia.service.article.ArticleService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 类LoginController.java的实现描述:登陆接口
 *
 * @author lala 2019年1月17日 上午11:29:18
 */
@Slf4j
@RestController
@RequestMapping("/article")
public class ArticleController {

    @Autowired
    private ArticleService articleService;

    /**
     * 方法描述: 获取查询文章列表
     *
     * @param request  request
     * @param response
     * @return
     * @author lala 2016年9月19日 下午8:02:02
     */
    @RequestMapping(value = "/getArticleList", method = {RequestMethod.GET} , produces = "application/json")
    public ResultModel<Page<ArticleVO>> getArticleList(
            @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
            @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            HttpServletRequest request, HttpServletResponse response) {
        return ResultModelFactory.SUCCESS(articleService.getArticleList(pageSize, pageNum));
    }

}
