package com.bxm.adsmedia.web.controller.base;

import com.bxm.adsmedia.common.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.concurrent.TimeUnit;

/**
 * Description 调用运营后台接口
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/15 10:36
 */
@Slf4j
@RestController
@RequestMapping("/common")
public class AdsmanagerController {

    @Value("${config.adsmanagerUrl}")
    private String adsmanagerUrl;


    private final static OkHttpClient CLIENT = new OkHttpClient.Builder()
            .connectTimeout(30, TimeUnit.SECONDS)
            .readTimeout(30, TimeUnit.SECONDS)
            .writeTimeout(30, TimeUnit.SECONDS)
            // 链接失败，不重试
            .retryOnConnectionFailure(false)
            .build();


    /**
     * Description: 获取运营媒体字典
     * JDK version used:<JDK1.8>
     * Create Date：2019/2/16 17:43
     *
     * @param typeGroupId 分类ID
     * @return java.lang.String
     * @author hxpeng
     */
    @RequestMapping(value = "/getDictionaries", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public String getDictionaries(@RequestParam(name = "typeGroupId") String typeGroupId) {
        if (StringUtils.isBlank(typeGroupId)) {
            throw new BusinessException("typeGroupId不能为空！");
        }
//        adsmanagerUrl = "http://localhost:18502";
        String path = adsmanagerUrl + "/common/findAll?typegroupid=" + typeGroupId;
        try {
            // 增加请求头，Connection， 防止长连接
            Request request = (new Request.Builder()).addHeader("Connection","close").url(path).get().build();
            Response response = CLIENT.newCall(request).execute();
            if (null != response && null != response.body()) {
                return response.body().string();
            }
        } catch (Exception e) {
            log.error("查询运营后台的媒体字典失败！", e);
        }
        throw new BusinessException("查询运营后台的媒体字典失败！");
    }

}
