package com.bxm.adsmedia.web.controller.base;

import com.bxm.adsmedia.common.exception.BusinessException;
import com.bxm.adsmedia.model.enums.CaptchaSceneEnum;
import com.bxm.adsmedia.service.common.CaptchaService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * Description 验证码相关
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/15 10:36
 */
@Slf4j
@RestController
@RequestMapping("/captcha")
public class CaptchaController {

    @Autowired
    private CaptchaService captchaService;

    /**
     * Description: 获取图片验证码
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/16 14:39
     *
     * @param uuid  uuid
     * @param scene 验证码场景
     * @return void
     * @author hxpeng
     */
    @RequestMapping(value = "/img/get", method = RequestMethod.GET)
    public void imgCaptchaGet(@RequestParam(name = "uuid") String uuid,
                              @RequestParam(name = "scene") Byte scene) {
        CaptchaSceneEnum sceneEnum = CaptchaSceneEnum.getByCode(scene);
        if (null == sceneEnum) {
            throw new BusinessException("参数非法！");
        }
        captchaService.imgCaptcha(sceneEnum, uuid);
    }

    /**
     * Description: 验证图片验证码
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/16 14:42
     *
     * @param uuid      uuid
     * @param sceneCode 验证码场景
     * @param captcha   用户输入的验证码
     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/img/verify", method = RequestMethod.GET)
    public ResultModel<Boolean> imgCaptchaVerify(@RequestParam(name = "uuid") String uuid,
                                                 @RequestParam(name = "sceneCode") Byte sceneCode,
                                                 @RequestParam(name = "captcha") String captcha) {
        CaptchaSceneEnum sceneEnum = CaptchaSceneEnum.getByCode(sceneCode);
        if (null == sceneEnum) {
            throw new BusinessException("参数非法！");
        }
        return ResultModelFactory.SUCCESS(captchaService.verifyImgCaptcha(sceneEnum, uuid, captcha));
    }

//    /**
//     * Description: 验证短信验证码
//     * JDK version used:<JDK1.8>
//     * Create Date：2019/1/22 13:47
//     *
//     * @param phoneNum  手机号
//     * @param sceneCode 场景
//     * @param captcha   验证码
//     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Boolean>
//     * @author hxpeng
//     */
//    @RequestMapping(value = "/sms/verify", method = RequestMethod.GET)
//    public ResultModel<Boolean> smsCaptchaVerify(@RequestParam(name = "phoneNum") String phoneNum,
//                                                 @RequestParam(name = "sceneCode") Byte sceneCode,
//                                                 @RequestParam(name = "captcha") String captcha) {
//        CaptchaSceneEnum sceneEnum = CaptchaSceneEnum.getByCode(sceneCode);
//        if (null == sceneEnum) {
//            throw new BusinessException("参数非法！");
//        }
//        return ResultModelFactory.SUCCESS(captchaService.verifySmsCaptcha(sceneEnum, phoneNum, captcha));
//    }

}
