package com.bxm.adsmedia.web.controller.base;

import com.bxm.adsmedia.common.enums.FileType;
import com.bxm.adsmedia.common.exception.BusinessException;
import com.bxm.adsmedia.common.util.FileTypeJudge;
import com.bxm.adsmedia.common.util.InputStreamUtil;
import com.bxm.warcar.file.upload.HttpFileManager;
import com.bxm.warcar.file.upload.HttpFileRequest;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.Set;

/**
 * Description 验证码相关
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/15 10:36
 */
@Slf4j
@RestController
@RequestMapping("/upload")
public class FileUploadController {

    /**
     * 允许上传的图片类型
     */
    private final static Set<String> ALLOW_IMG_TYPE_SET = Sets.newHashSet(
            FileType.JPG.getCode(),
            FileType.PNG.getCode(),
            FileType.GIF.getCode());
    /**
     * 最大上传图片 3m
     */
    private final static long MAX_UPLOAD_IMG_SIZE = 3 * 1024 * 1024L;

    @Autowired
    private HttpFileManager httpFileManager;

    /**
     * Description: 上传图片
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/17 13:51
     *
     * @param file 上传的文件
     * @return java.lang.String
     * @author hxpeng
     */
    @RequestMapping(value = "/img", method = {RequestMethod.POST})
    public String uploadImg(@RequestParam("img") MultipartFile file) throws Exception {
        if (file.isEmpty()) {
            throw new BusinessException("上传文件不能为空！");
        }
        if (file.getSize() > MAX_UPLOAD_IMG_SIZE) {
            throw new BusinessException("上传文件不能大于3M！");
        }
        // FileTypeJudge.getTypeByInputStream 会关闭文件流
        FileType fileType = FileTypeJudge.getTypeByInputStream(InputStreamUtil.copy(file.getInputStream()));
        if (null == fileType || !ALLOW_IMG_TYPE_SET.contains(fileType.getCode())) {
            throw new BusinessException("请上传正确类型的文件！");
        }
        String uploadPath = httpFileManager.upload(new HttpFileRequest(file));
        log.info("img upload success, the url : {} ", uploadPath);
        return uploadPath;
    }

}
