package com.bxm.adsmedia.web.controller.income;

import com.bxm.adsmedia.common.context.user.UserSessionContext;
import com.bxm.adsmedia.model.vo.income.ProfitVO;
import com.bxm.adsmedia.service.income.AppIncomeLogService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 拉拉
 * @fileName com.bxm.adsmedia.web.controller.income.AppIncomeLogController.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2019-01-17 09:57:00
 * @modifier 拉拉
 * @updated 2019-01-17 09:57:00
 */
@RestController
@RequestMapping("/appIncomeLog")
public class AppIncomeLogController {

    @Autowired
    private AppIncomeLogService appIncomeLogService;


    @RequestMapping(value = "/getProfit", method = {RequestMethod.GET})
    public ResultModel<ProfitVO> getAppIncomeLog() {
        ProfitVO pfv = appIncomeLogService.getAllProfit(UserSessionContext.getAppKey());
        return ResultModelFactory.SUCCESS(pfv);
    }
}
