package com.bxm.adsmedia.web.controller.income;

import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.adsmedia.common.context.user.UserSessionContext;
import com.bxm.adsmedia.common.exception.BusinessException;
import com.bxm.adsmedia.model.enums.CaptchaSceneEnum;
import com.bxm.adsmedia.model.vo.income.CashApplyLogVO;
import com.bxm.adsmedia.service.common.CaptchaService;
import com.bxm.adsmedia.service.income.CashApplyLogService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Description 提现记录
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/21 19:42
 */
@RestController
@RequestMapping("/cashApplyLog")
public class CashApplyLogController {

    @Autowired
    private CashApplyLogService cashApplyLogService;
    @Autowired
    private CaptchaService captchaService;


    /**
     * Description: 获取申请提现记录列表
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/21 19:44
     *
     * @param pageNum  页码
     * @param pageSize 页面大小
     * @return com.bxm.warcar.utils.response.ResultModel<com.baomidou.mybatisplus.plugins.Page<com.bxm.adsmedia.model.vo.income.CashApplyLogVO>>
     * @author hxpeng
     */
    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public ResultModel<Page<CashApplyLogVO>> getPage(@RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                     @RequestParam(name = "pageSize", defaultValue = "15") Integer pageSize) {
        return ResultModelFactory.SUCCESS(cashApplyLogService.getPage(UserSessionContext.getProviderId(), pageNum, pageSize));
    }

    /**
     * Description: 提现申请--发送验证码
     * JDK version used:<JDK1.8>
     * Create Date：2019/2/15 18:12
     *
     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/captcha", method = RequestMethod.GET)
    public ResultModel<Boolean> forgetPwdSmsCaptchaGet() {
        return ResultModelFactory.SUCCESS(captchaService.smsCaptcha(CaptchaSceneEnum.APPLY_INCOME_CASH, UserSessionContext.getPhoneNum(), "【变现猫】您当前申请提现收益，获取的验证码是："));
    }

    /**
     * Description: 提现申请
     * JDK version used:<JDK1.8>
     * Create Date：2019/2/13 20:16

     * @param captcha 验证码
     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Long>
     * @author hxpeng
     */
    @RequestMapping(value = "/applyIncomeCash", method = RequestMethod.POST)
    public ResultModel<Long> applyIncomeCash(@RequestParam(name = "captcha") String captcha) {
        if (!captchaService.verifySmsCaptcha(CaptchaSceneEnum.APPLY_INCOME_CASH, UserSessionContext.getPhoneNum(), captcha)) {
            throw new BusinessException("验证码输入错误！");
        }
        return ResultModelFactory.SUCCESS(cashApplyLogService.applyIncomeCash());
    }

    /**
     * Description: 判断是否有资格提现
     * JDK version used:<JDK1.8>
     * Create Date：2019/2/13 17:52
     *
     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/checkApplyIncomeCashQualifications", method = RequestMethod.GET)
    public ResultModel<Boolean> checkApplyIncomeCashQualifications() {
        return ResultModelFactory.SUCCESS(cashApplyLogService.checkApplyIncomeCashQualifications(UserSessionContext.getProviderId()));
    }


}
