package com.bxm.adsmedia.web.controller.income;

import com.bxm.adsmedia.service.income.CashApplyLogSnapshotService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Description 下载 申请提现确认函
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/21 20:02
 */
@RestController
@RequestMapping("/cashApplyLogSnapshot")
public class CashApplyLogSnapshotController {

    @Autowired
    private CashApplyLogSnapshotService cashApplyLogSnapshotService;

    /**
     * Description: 下载
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/21 20:48
     *
     * @param applyCashLogId 申请提现记录ID
     * @return void
     * @author hxpeng
     */
    @RequestMapping(value = "/download", method = RequestMethod.GET)
    public void download(@RequestParam(name = "applyCashLogId") Long applyCashLogId,
                         @RequestParam(name = "token") String token) {
        cashApplyLogSnapshotService.download(applyCashLogId, token);
    }

}
