package com.bxm.adsmedia.web.controller.income;

import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.adsmedia.common.exception.BusinessException;
import com.bxm.adsmedia.model.enums.IncomeLogStatusEnum;
import com.bxm.adsmedia.model.vo.income.IncomeLogRangeVO;
import com.bxm.adsmedia.model.vo.income.IncomeLogVO;
import com.bxm.adsmedia.service.income.IncomeLogService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * Description 收益
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/21 15:27
 */
@RestController
@RequestMapping("/incomeLog")
public class IncomeLogController {

    @Autowired
    private IncomeLogService incomeLogService;

    /**
     * Description: 可申请提现的收益列表
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/21 15:36
     *
     * @param beginDate 开始时间
     * @param endDate   结束时间
     * @param status    状态：0未体现，1已提现 ，2 审核中
     * @param pageNum   页码
     * @param pageSize  页面大小
     * @return com.bxm.warcar.utils.response.ResultModel<com.baomidou.mybatisplus.plugins.Page<com.bxm.adsmedia.model.vo.income.IncomeLogVO>>
     * @author hxpeng
     */
    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public ResultModel<Page<IncomeLogVO>> getPage(@RequestParam(name = "beginDate") @DateTimeFormat(pattern = "yyyy-MM-dd") Date beginDate,
                                                  @RequestParam(name = "endDate") @DateTimeFormat(pattern = "yyyy-MM-dd") Date endDate,
                                                  @RequestParam(name = "status", required = false) Byte status,
                                                  @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                  @RequestParam(name = "pageSize", defaultValue = "50") Integer pageSize) {
        IncomeLogStatusEnum incomeLogStatusEnum;
        if (null == status) {
            incomeLogStatusEnum = IncomeLogStatusEnum.UN_APPLY;
        } else {
            incomeLogStatusEnum = IncomeLogStatusEnum.getByCode(status);
        }
        if (null == incomeLogStatusEnum) {
            throw new BusinessException("请填入正确的参数！");
        }
        if (endDate.before(beginDate)) {
            throw new BusinessException("请填入正确的参数！");
        }
        return ResultModelFactory.SUCCESS(incomeLogService.getPage(beginDate, endDate, incomeLogStatusEnum.getCode(), pageNum, pageSize));
    }

    /**
     * Description: 申请提现，返回 具体时间 以及 总共可提现金额
     * JDK version used:<JDK1.8>
     * Create Date：2019/2/12 14:34
     *
     * @return com.bxm.warcar.utils.response.ResultModel<com.bxm.adsmedia.model.vo.income.IncomeLogRangeVO>
     * @author hxpeng
     */
    @RequestMapping(value = "/getIncomeLogSpecificRange", method = RequestMethod.GET)
    public ResultModel<IncomeLogRangeVO> getIncomeLogSpecificRange() {
        IncomeLogRangeVO incomeLogRangeVO = incomeLogService.getIncomeLogSpecificRange();
        if (null != incomeLogRangeVO) {
            incomeLogRangeVO.setIncomeLogIdsStr("");
        }
        return ResultModelFactory.SUCCESS(incomeLogRangeVO);
    }


}
