package com.bxm.adsmedia.web.controller.manual;
import com.bxm.adsmedia.service.timer.AdvanceFlowRecordTimer;
import com.bxm.adsmedia.service.timer.RefreshPositionsOnlineTimeTimer;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wangchao
 * @description 定时器调度接口
 * @date 2019/03/22 10:46
 */
@RestController
@RequestMapping("/common")
public class ManualController {

    @Autowired
    private RefreshPositionsOnlineTimeTimer refreshPositionsOnlineTimeTimer;

    @Autowired
    private AdvanceFlowRecordTimer advanceFlowRecordTimer;

    /*  
     * @description 每天凌晨三点刷新广告位在线时间
     * @date 2019/3/22 15:17
     */
    @RequestMapping("/onlineTime")
    public ResultModel refreshPositionsOnlineTime() throws Exception {
        refreshPositionsOnlineTimeTimer.execute();
        return ResultModelFactory.SUCCESS();
    }

    /*
    * @description 每天凌晨四点刷新昨天记录的前天的消耗流水记录
    * @date 2019/3/22 15:17
    */
    @RequestMapping("/advanceFlow")
    public ResultModel updateAdvanceFlowRecord() throws Exception {
        advanceFlowRecordTimer.execute();
        return ResultModelFactory.SUCCESS();
    }
    /*
     * @description 每天凌晨三点刷新广告位下线时间
     * @date 2019/3/22 15:17
     */
    @RequestMapping("/downTime")
    public ResultModel refreshPositionsdownTime() throws Exception {
        refreshPositionsOnlineTimeTimer.downTimeexecute();
        return ResultModelFactory.SUCCESS();
    }
}
