package com.bxm.adsmedia.web.controller.media;

import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.adsmedia.common.context.user.UserSessionContext;
import com.bxm.adsmedia.common.exception.BusinessException;
import com.bxm.adsmedia.model.dto.media.UpdateAppEntranceDTO;
import com.bxm.adsmedia.model.vo.media.AppEntranceInfoVO;
import com.bxm.adsmedia.model.vo.media.AppEntranceVO;
import com.bxm.adsmedia.service.media.AppEntranceService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

/**
 * Description 广告位
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/18 18:25
 */
@Validated
@RestController
@RequestMapping("/appEntrance")
public class AppEntranceController {

    @Autowired
    private AppEntranceService appEntranceService;


    /**
     * Description: 列表
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/18 18:54
     *
     * @param appEntranceName 广告位名称
     * @param pageNum         页码
     * @param pageSize        页面大小
     * @return com.bxm.warcar.utils.response.ResultModel<com.baomidou.mybatisplus.plugins.Pagecom.bxm.adsmedia.model.vo.media.AppEntranceVO>>
     * @author hxpeng
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResultModel<Page<AppEntranceVO>> list(@RequestParam(name = "appEntranceName", required = false) String appEntranceName,
                                                 @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                 @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        return ResultModelFactory.SUCCESS(appEntranceService.getPage(appEntranceName, pageNum, pageSize));
    }

    /**
     * Description: 列表
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/18 18:54
     *
     * @return com.bxm.warcar.utils.response.ResultModel<com.baomidou.mybatisplus.plugins.Page<com.bxm.adsmedia.model.vo.media.AppEntranceVO>>
     * @params mediaId
     * @author hxpeng
     */
    @RequestMapping(value = "/getPageListByMediaId", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<Page<AppEntranceVO>> getPageListByMediaId(@RequestParam(name = "mediaId") String mediaId,
                                                                 @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                                 @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        return ResultModelFactory.SUCCESS(appEntranceService.getPageListByMediaId(mediaId, pageNum, pageSize));
    }

    /**
     * Description: 获取广告位信息，根据主键
     * JDK version used:<JDK1.8>
     * Create Date：2019/2/13 11:38
     *
     * @param id 主键
     * @return com.bxm.warcar.utils.response.ResultModel<com.bxm.adsmedia.model.vo.media.AppEntranceInfoVO>
     * @author hxpeng
     */
    @RequestMapping(value = "/get", method = RequestMethod.GET)
    public ResultModel<AppEntranceInfoVO> get(@NotNull(message = "id不能为空！") @RequestParam(name = "id") Long id) {
        return ResultModelFactory.SUCCESS(appEntranceService.get(id));
    }

    /**
     * Description: 新增广告位
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/18 19:16
     *
     * @param dto 参数
     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultModel<Boolean> add(@Validated @RequestBody UpdateAppEntranceDTO dto) {
        if (!dto.getDspFlag()) {
            if (StringUtils.isBlank(dto.getEntrancePicUrl())) {
                throw new BusinessException("入口场景图片不能为空！");
            }
        }
        return ResultModelFactory.SUCCESS(appEntranceService.add(UserSessionContext.getProviderId(), dto));
    }

    /**
     * Description: 修改广告位
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/18 19:16
     *
     * @param dto 参数
     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultModel<Boolean> update(@Validated @RequestBody UpdateAppEntranceDTO dto) {
        if (null == dto.getId()) {
            throw new BusinessException("id 不能为空！");
        }
        if (!dto.getDspFlag()) {
            if (StringUtils.isBlank(dto.getEntrancePicUrl())) {
                throw new BusinessException("入口场景图片不能为空！");
            }
        }
        return ResultModelFactory.SUCCESS(appEntranceService.update(dto));
    }
}
