package com.bxm.adsmedia.web.controller.media;

import com.bxm.adsmedia.dal.entity.PositionClassType;
import com.bxm.adsmedia.service.media.PositionClassTypeService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Description 媒体分类
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/16 20:01
 */
@Slf4j
@RestController
@RequestMapping("/manage")
public class PositionClassTypeController {

    @Autowired
    private PositionClassTypeService positionClassTypeService;

    @RequestMapping(value = "/getPositionClassType", method = RequestMethod.GET)
    public ResultModel<List<PositionClassType>> queryPositionClassTypeList(@RequestParam(value = "parentId", defaultValue = "0") Long parentId,
                                                                           @RequestParam(value = "typeCode", defaultValue = "1") String typeCode) {
        return ResultModelFactory.SUCCESS(positionClassTypeService.queryList(parentId, typeCode));
    }


}
