package com.bxm.adsmedia.web.controller.operate;

import java.util.ArrayList;
import java.util.List;

import com.bxm.adsmedia.common.context.user.UserSessionContext;
import com.bxm.adsmedia.common.entity.User;
import com.bxm.adsmedia.common.exception.BusinessException;
import com.bxm.adsmedia.model.vo.operate.EntranceMsgVo;
import com.bxm.adsmedia.service.common.CommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmedia.common.context.user.RequestInfoContext;
import com.bxm.adsmedia.common.util.ExcelUtil;
import com.bxm.adsmedia.model.dto.income.IncomeByDateDto;
import com.bxm.adsmedia.model.vo.operate.AppEntranceIncomeVO;
import com.bxm.adsmedia.model.vo.operate.AppEntranceTodateVO;
import com.bxm.adsmedia.model.vo.operate.ProfitByDataVO;
import com.bxm.adsmedia.service.operate.OperateService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 类LoginController.java的实现描述:运营数据
 *
 * @author lala 2019年1月16日 上午11:29:18
 */
@RestController
@RequestMapping("/operate")
public class OperateController {

    @Autowired
    private OperateService operateService;
    @Autowired
    private CommonService commonService;

    /**
     * 方法描述: 开发者运营数据：每日预估收益、UV访问量，PV访问量 (图表)
     *
     * @return
     * @author lala
     */
    @RequestMapping(value = "/userChart", method = {RequestMethod.GET}, produces = "application/json")
    public ResultModel<List<ProfitByDataVO>> userChart(@RequestParam(value = "startTime") String startTime,
                                                       @RequestParam(value = "endTime") String endTime) {
        IncomeByDateDto incomeByDateDto = new IncomeByDateDto();
        incomeByDateDto.setStartTime(startTime);
        incomeByDateDto.setEndTime(endTime);
        incomeByDateDto.setAppKey(UserSessionContext.getAppKey());
        List<ProfitByDataVO> ov = operateService.getOperateDataByAppKeyAndTime(incomeByDateDto);
        return ResultModelFactory.SUCCESS(ov);
    }

    /**
     * @return void
     * @description: 导出开发者预估收益，可提现收益，未体现收益、PV、UV数据
     * @author: lala
     * @time: 2019/1/17 11:10
     */
    @RequestMapping(value = "/exportExcelUserChart")
    public void exportExcelUserChart(@RequestParam(value = "startTime") String startTime,
                                     @RequestParam(value = "endTime") String endTime,
                                     @RequestParam(value = "token") String token) {
        User user = commonService.getUserByToken(token);
        if (null == user) {
            throw new BusinessException("token不正确！");
        }
        IncomeByDateDto incomeByDateDto = new IncomeByDateDto();
        incomeByDateDto.setStartTime(startTime);
        incomeByDateDto.setEndTime(endTime);
        incomeByDateDto.setAppKey(user.getAppKey());
        List<ProfitByDataVO> ovList = operateService.getOperateDataByAppKeyAndTime(incomeByDateDto);
        // 导出操作
        ExcelUtil.exportExcel(ovList, null, "收益统计", ProfitByDataVO.class, startTime + "至" + endTime + "收益统计.xls",
                RequestInfoContext.getResponse());

    }

    /**
     * 方法描述: 开发者运营数据：每日预估收益、UV访问量，PV访问量 按照广告位维度
     *
     * @return
     * @author lala
     */
    @Deprecated
    @RequestMapping(value = "/getAppIncomeByType", method = {RequestMethod.GET}, produces = "application/json")
    public ResultModel<List<AppEntranceIncomeVO>> getAppIncomeByType(
            @RequestParam(value = "startTime") String startTime, @RequestParam(value = "endTime") String endTime,
            @RequestParam(value = "type") int type) {
        IncomeByDateDto incomeByDateDto = new IncomeByDateDto();
        incomeByDateDto.setStartTime(startTime);
        incomeByDateDto.setEndTime(endTime);
        incomeByDateDto.setType(type);
        incomeByDateDto.setAppKey(UserSessionContext.getAppKey());
        //incomeByDateDto.setAppKey("0004e5697dea417cb26bf98cdcbd8f1f");
        List<AppEntranceIncomeVO> list = new ArrayList<>();
        if (type == 1) {
            //按时间查找预估收益的pvuv，是一个list
            list = operateService.getAppEntrancePrepareIncomeInfo(incomeByDateDto);
        } else {
            //可按时间提现收益与已提现收益的pvuv，只有一条数据
            list = operateService.getAppMediaEntranceIncomeInfo(incomeByDateDto);
        }
        return ResultModelFactory.SUCCESS(list);
    }


    /**
     * 方法描述: 开发者运营数据：根据开发者广告位获取某个时间段的uv和收益列表
     *
     * @return
     * @author lala
     */
    @Deprecated
    @RequestMapping(value = "/getAppEntranceIncomeToDateByType", method = {RequestMethod.GET}, produces = "application/json")
    public ResultModel<List<AppEntranceTodateVO>> getAppEntranceIncomeToDate(
            @RequestParam(value = "startTime") String startTime, @RequestParam(value = "endTime") String endTime,
            @RequestParam(value = "appEntranceId", required = false) String appEntranceId,
            @RequestParam(value = "mediaId", required = false) String mediaId,
            @RequestParam(value = "type", defaultValue = "1") int type) {
        IncomeByDateDto incomeByDateDto = new IncomeByDateDto();
        incomeByDateDto.setStartTime(startTime);
        incomeByDateDto.setEndTime(endTime);
        incomeByDateDto.setAppEntranceId(appEntranceId);
        incomeByDateDto.setType(type);
        incomeByDateDto.setMediaId(mediaId);
        incomeByDateDto.setAppKey(UserSessionContext.getAppKey());
        List<AppEntranceTodateVO> list = operateService.getIncomeInfoByParams(incomeByDateDto);
        return ResultModelFactory.SUCCESS(list);
    }

    /**
     * 方法描述: 开发者运营数据：导出根据开发者广告位或者媒体id获取某个时间段的uv和收益列表
     *
     * @return
     * @author lala
     */
    @Deprecated
    @RequestMapping(value = "/exportAppEntranceIncomeToDateByType", method = {RequestMethod.GET})
    public void exportAppEntranceIncomeToDate(@RequestParam(value = "startTime") String startTime, @RequestParam(value = "endTime") String endTime,
                                              @RequestParam(value = "appEntranceId", required = false) String appEntranceId,
                                              @RequestParam(value = "mediaId", required = false) String mediaId,
                                              @RequestParam(value = "type", defaultValue = "1") int type,
                                              @RequestParam(value = "token") String token) {
        User user = commonService.getUserByToken(token);
        if (null == user) {
            throw new BusinessException("token不正确！");
        }
        IncomeByDateDto incomeByDateDto = new IncomeByDateDto();
        incomeByDateDto.setStartTime(startTime);
        incomeByDateDto.setEndTime(endTime);
        incomeByDateDto.setAppEntranceId(appEntranceId);
        incomeByDateDto.setType(type);
        incomeByDateDto.setMediaId(mediaId);
        incomeByDateDto.setAppKey(user.getAppKey());
        List<AppEntranceTodateVO> list = operateService.getIncomeInfoByParams(incomeByDateDto);
        // 导出操作
        ExcelUtil.exportExcel(list, null, "广告位收益数据", AppEntranceTodateVO.class, "广告位按天收益数据.xls",
                RequestInfoContext.getResponse());


    }
    /**
     * @description: 导出开发者运营数据收益、PV、UV数据（每天一个合计）
     * @author: JandMin
     * @time: 2018/7/9 11:10
     * @return void
     */
    @RequestMapping(value = "/exportExcelApi")
    public void exportExcelApiInfo(@RequestParam(value = "startTime") String startTime,
                                   @RequestParam(value = "endTime") String endTime,
                                   @RequestParam(value = "token") String token) {
        //String appKey = "0004e5697dea417cb26bf98cdcbd8f1f";
        User user = commonService.getUserByToken(token);
        String appKey= user.getAppKey();
        List<EntranceMsgVo> entranceMsgList = operateService.getExportExcelApiInfo(appKey, startTime, endTime);
        // 导出操作
        ExcelUtil.exportExcel(entranceMsgList, null, "广告-运营数据", EntranceMsgVo.class, "广告-运营数据.xls", RequestInfoContext.getResponse());
    }

}
