package com.bxm.adsmedia.web.controller.provider;

import com.bxm.adsmedia.common.context.user.UserSessionContext;
import com.bxm.adsmedia.common.exception.BusinessException;
import com.bxm.adsmedia.model.dto.provider.UpdateProviderFinanceDTO;
import com.bxm.adsmedia.model.enums.CaptchaSceneEnum;
import com.bxm.adsmedia.model.vo.provider.ProviderFinanceVO;
import com.bxm.adsmedia.service.common.CaptchaService;
import com.bxm.adsmedia.service.common.CommonService;
import com.bxm.adsmedia.service.provider.ProviderFinanceService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * Description 开发者财务信息
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/16 20:14
 */
@Validated
@RestController
@RequestMapping("/provider/finance")
public class ProviderFinanceInfoController {

    @Autowired
    private ProviderFinanceService providerFinanceService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private CaptchaService captchaService;

    /**
     * Description: 获取开发者财务信息
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/16 20:53
     *
     * @return com.bxm.warcar.utils.response.ResultModel<com.bxm.adsmedia.model.vo.provider.ProviderFinanceVO>
     * @author hxpeng
     */
    @RequestMapping(value = "/get", method = RequestMethod.GET)
    public ResultModel<ProviderFinanceVO> get() {
        return ResultModelFactory.SUCCESS(providerFinanceService.findByProviderId(UserSessionContext.getProviderId()));
    }

    /**
     * Description: 开发者操作财务信息-短信验证码
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/22 17:18
     *
     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/smsCaptcha", method = RequestMethod.GET)
    public ResultModel<Boolean> smsCaptchaGet() {
        return ResultModelFactory.SUCCESS(captchaService.smsCaptcha(CaptchaSceneEnum.EDIT_PROVIDE_FINANCE, UserSessionContext.getPhoneNum(), "【变现猫】您当前正在修改开发者财务信息，获取的验证码是："));
    }


    /**
     * Description: 开发者新增财务信息
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/16 21:15
     *
     * @param dto     参数
     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/create", method = RequestMethod.POST)
    public ResultModel<Boolean> create(@Validated @RequestBody UpdateProviderFinanceDTO dto) {
        // 校验验证码
        if (!captchaService.verifySmsCaptcha(CaptchaSceneEnum.EDIT_PROVIDE_FINANCE, UserSessionContext.getPhoneNum(), dto.getCaptcha())) {
            throw new BusinessException("创建失败，验证码输入错误！");
        }
        dto.setProviderId(UserSessionContext.getProviderId());
        return ResultModelFactory.SUCCESS(providerFinanceService.create(UserSessionContext.getProviderId(), dto));
    }


    /**
     * Description: 开发者修改财务信息
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/16 21:15
     *
     * @param dto     参数
     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultModel<Boolean> update(@Validated @RequestBody UpdateProviderFinanceDTO dto) {

        // 校验验证码
        if (!captchaService.verifySmsCaptcha(CaptchaSceneEnum.EDIT_PROVIDE_FINANCE, UserSessionContext.getPhoneNum(), dto.getCaptcha())) {
            throw new BusinessException("创建失败，验证码输入错误！");
        }
        dto.setProviderId(UserSessionContext.getProviderId());
        return ResultModelFactory.SUCCESS(providerFinanceService.update(dto));
    }

}
