package com.bxm.adsmedia.web.controller.stationMsg;

import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.adsmedia.common.context.user.UserSessionContext;
import com.bxm.adsmedia.model.vo.stationMsg.StationMsgVO;
import com.bxm.adsmedia.service.stationMsg.StationMsgService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;

/**
 * Description 站内信
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/19 15:26
 */
@Validated
@RestController
@RequestMapping("/stationMsg")
public class StationMsgController {

    @Autowired
    private StationMsgService stationMsgService;

    /**
     * Description: 获取站内信列表
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/19 15:34
     *
     * @param pageNum  页码
     * @param pageSize 页面大小
     * @return com.bxm.warcar.utils.response.ResultModel<com.baomidou.mybatisplus.plugins.Page < com.bxm.adsmedia.model.vo.stationMsg.StationMsgVO>>
     * @author hxpeng
     */
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    public ResultModel<Page<StationMsgVO>> getPage(@RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                   @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize) {
        return ResultModelFactory.SUCCESS(stationMsgService.getPage(UserSessionContext.getProviderId(), pageNum, pageSize));
    }


    /**
     * Description: 获取当前登录用户得未读消息
     * JDK version used:<JDK1.8>
     * Create Date：2019/2/14 9:53
     *
     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Integer>
     * @author hxpeng
     */
    @RequestMapping(value = "/getUnreadMsgCount")
    public ResultModel<Integer> getUnreadMsgCount() {
        return ResultModelFactory.SUCCESS(stationMsgService.getUnreadMsgCount(UserSessionContext.getProviderId()));
    }

    /**
     * Description: 已读站内信
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/23 11:47
     *
     * @param id 消息ID
     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/read", method = RequestMethod.GET)
    public ResultModel<Boolean> read(@NotNull(message = "id不能为空！") @RequestParam("id") Long id) {
        return ResultModelFactory.SUCCESS(stationMsgService.read(id));
    }


    /**
     * Description: 删除站内信
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/23 11:47
     *
     * @param id 消息ID
     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    public ResultModel<Boolean> delete(@NotNull(message = "id不能为空！") @RequestParam("id") Long id) {
        return ResultModelFactory.SUCCESS(stationMsgService.delete(id));
    }

}
