package com.bxm.adsmedia.web.controller.third;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bxm.adsmedia.model.vo.third.AppProductIncomeVo;
import com.bxm.adsmedia.service.third.AdApiService;
import com.bxm.warcar.utils.response.ResultModel;

/**
 * @author api第三方接口
 */
@RequestMapping("/ad")
@Controller
public class AdApiController {

	@Resource
	private AdApiService adApiService;

	/**
	 * @return com.mige.baseframe.dto.ResultModel<com.mige.site.dto.index.AppProductIncome>
	 * @description: 开发者运营数据：广告位收益
	 */
	@RequestMapping(value = "/getAppEntranceIncome", method = RequestMethod.GET)
	@ResponseBody
	public ResultModel<AppProductIncomeVo> getAppEntranceIncome(@RequestParam(value = "appKey") String appKey,
			@RequestParam(value = "appSecret") String appSecret) {
		ResultModel<AppProductIncomeVo> result = new ResultModel<>();
		result.setReturnValue(adApiService.getAppEntranceIncomeInfo(appKey, appSecret));
		return result;
	}

}
