package com.bxm.adsmedia.web.facade.controller;

import com.bxm.adsmedia.common.exception.BusinessException;
import com.bxm.adsmedia.facade.model.provider.advance.AdvanceAppFlowRecordRO;
import com.bxm.adsmedia.facade.model.provider.advance.AdvanceAppFlowRecordTotalRO;
import com.bxm.adsmedia.facade.model.provider.advance.QueryAdvanceAppParamsDTO;
import com.bxm.adsmedia.facade.service.AdvanceAppFlowRecordFacadeService;
import com.bxm.adsmedia.service.provider.facade.FacadeAdvanceAppFlowRecordService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Description 预存媒体流水记录
 *
 * @author hxpeng
 * <p>
 * Date 2019/2/20 11:50
 */
@Slf4j
@RestController
public class AdvanceAppFlowRecordFacadeServiceImpl implements AdvanceAppFlowRecordFacadeService {

    @Autowired
    private FacadeAdvanceAppFlowRecordService facadeAdvanceAppFlowRecordService;

    @Override
    public ResultModel<PageInfo<AdvanceAppFlowRecordTotalRO>> getAdvanceAppSumFlowRecord(@RequestBody QueryAdvanceAppParamsDTO paramsDTO) {
        return ResultModelFactory.SUCCESS(facadeAdvanceAppFlowRecordService.getAdvanceAppSumFlowRecord(paramsDTO));
    }

    @Override
    public ResultModel<PageInfo<AdvanceAppFlowRecordRO>> getAdvanceAppFlowRecords(String appKey, String startTimeStr, String endTimeStr, Integer onlyShowRechargeFlag, Integer pageNum, Integer pageSize) {
        if (StringUtils.isBlank(appKey)) {
            throw new BusinessException("请检查参数！");
        }
        Date startTime = null;
        Date endTime = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

        try {
            if (StringUtils.isNotBlank(startTimeStr)) {
                startTime = simpleDateFormat.parse(startTimeStr);
            }
            if (StringUtils.isNotBlank(endTimeStr)) {
                endTime = simpleDateFormat.parse(endTimeStr);
            }
        } catch (ParseException e) {
            throw new BusinessException("请输入正确的时间！");
        }
        return ResultModelFactory.SUCCESS(facadeAdvanceAppFlowRecordService.getAdvanceAppFlowRecords(appKey, onlyShowRechargeFlag, startTime, endTime, pageNum, pageSize));
    }
}
