package com.bxm.adsmedia.web.facade.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.bxm.acl.facade.model.UserRo;
import com.bxm.adsmedia.common.exception.BusinessException;
import com.bxm.adsmedia.common.util.DateUtil;
import com.bxm.adsmedia.common.util.RegExpValidatorUtils;
import com.bxm.adsmedia.dal.entity.Provider;
import com.bxm.adsmedia.dal.entity.ReviewRefuseConfig;
import com.bxm.adsmedia.dal.mapper.ReviewRefuseConfigMapper;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAuditVO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceCountByAppKeyVO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceMinOnlineTimeByAppKeyVO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppAdPositionDTO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceByMinOnlineTimeParamDTO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.adsmedia.facade.model.appentrance.QueryPositionIdAndNameVo;
import com.bxm.adsmedia.facade.model.appentrance.UpdateAppEntranceDTO;
import com.bxm.adsmedia.facade.service.AppEntranceFacadeService;
import com.bxm.adsmedia.integration.acl.AclUserIntegration;
import com.bxm.adsmedia.model.constant.Constant;
import com.bxm.adsmedia.service.common.MailService;
import com.bxm.adsmedia.service.media.facade.FacadeAppEntranceService;
import com.bxm.adsmedia.service.provider.facade.FacadeProviderFinanceService;
import com.bxm.adsmedia.service.provider.facade.FacadeProviderService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Splitter;

import lombok.extern.slf4j.Slf4j;

/**
 * Description 广告位facade controller
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/23 17:20
 */
@Slf4j
@RestController
public class AppEntranceFacadeServiceImpl implements AppEntranceFacadeService {

    @Autowired
    private FacadeAppEntranceService facadeAppEntranceService;
    @Autowired
    private FacadeProviderFinanceService facadeProviderFinanceService;
    @Autowired
    private MailService mailService;
    @Autowired
    private FacadeProviderService facadeProviderService;
    @Autowired
    private ReviewRefuseConfigMapper reviewRefuseConfigMapper;
    @Autowired
    private AclUserIntegration aclUserIntegration;

    @Override
    public ResultModel<AppEntranceAdRO> findByPositionId(String positionId) {
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.find(positionId));
    }

    @Override
    public ResultModel<List<AppEntranceAdRO>> findListByPositionIds(String positionIdsStr) {
        if (StringUtils.isBlank(positionIdsStr)) {
            return ResultModelFactory.FAILED400("positionIdsStr is null！");
        }
        List<String> positionIds = Splitter.on(Constant.BaseCharacter.COMMA_EN).omitEmptyStrings().splitToList(positionIdsStr);
        if (CollectionUtils.isEmpty(positionIds)) {
            return ResultModelFactory.FAILED400("positionIds.size is zero！");
        }
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.findListByPositionIds(positionIds));
    }

    @Override
    public ResultModel<List<AppEntranceAdRO>> findByFuzzyProviderAlias(String providerAlias) {
        if (StringUtils.isBlank(providerAlias)) {
            throw new BusinessException("providerAlias cant be null ！");
        }
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.findByFuzzyProviderAlias(providerAlias));
    }

    @Override
    public ResultModel<List<AppEntranceAdRO>> findByIds(String idsStr) {
        if (StringUtils.isBlank(idsStr)) {
            throw new BusinessException("idsStr is null！");
        }
        List<Long> ids = Splitter.on(Constant.BaseCharacter.COMMA_EN)
                .omitEmptyStrings()
                .splitToList(idsStr)
                .stream()
                .map(Long::valueOf)
                .collect(Collectors.toList());
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.findByIds(ids));
    }

    @Override
    public ResultModel<PageInfo<AppEntranceAdRO>> getPage(@RequestBody QueryAppEntranceParamDTO dto) {
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.getPageInFacade(dto));
    }

    @Override
    public ResultModel<PageInfo<AppEntranceAuditVO>> getAuditPage(String keywords, Byte status,Long providerId, String mjCode, Integer pageNum, Integer pageSize) {
        pageNum = pageNum == null ? 1 : pageNum;
        pageSize = pageSize == null ? 15 : pageSize;
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.getAuditPage(keywords, status,providerId, mjCode, pageNum, pageSize));
    }

    @Override
    public ResultModel<List<Long>> batchAudit(String idsStr, Boolean auditPass, Boolean isMJ, String refuseReason,
                                           String reviewRefuseIds, String modifier) {
        if (StringUtils.isBlank(idsStr) || null == auditPass || StringUtils.isBlank(modifier)) {
            throw new BusinessException("参数不正确！");
        }
        //if (!auditPass && StringUtils.isBlank(reviewRefuseIds)) {
        //    throw new BusinessException("拒绝原因不能为空！");
        //}
        List<Long> ids = Splitter.on(Constant.BaseCharacter.COMMA_EN)
                .trimResults()
                .omitEmptyStrings()
                .splitToList(idsStr)
                .stream()
                .map(Long::valueOf)
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("ID集合字符串不能为空！");
        }
        String reviewRefuseIdsDesc = "";
        if (StringUtils.isNotBlank(reviewRefuseIds)) {
            List<Long> refuseIds = Arrays.asList(reviewRefuseIds.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List<ReviewRefuseConfig> reviewRefuseConfigList = reviewRefuseConfigMapper.getListByIds(refuseIds);
            if (CollectionUtils.isNotEmpty(reviewRefuseConfigList)) {
                StringBuffer refuseReasonStringBuffer = new StringBuffer();
                for (ReviewRefuseConfig reviewRefuseConfig : reviewRefuseConfigList) {
                    refuseReasonStringBuffer.append("<div>").append(reviewRefuseConfig.getMediaShowReason()).append("\t").append(reviewRefuseConfig.getAdvise()).append("</div>");
                }
                reviewRefuseIdsDesc = refuseReasonStringBuffer.toString();
            }
        }
        //返回成功更新的id列表
        List<Long> successIds = facadeAppEntranceService.batchAudit(ids, auditPass, isMJ, refuseReason, reviewRefuseIds,
                reviewRefuseIdsDesc.replaceAll("<div>", "").replaceAll("</div>", ""), modifier);
        if (successIds!=null&&successIds.size()>0) {
            //查询成功更新的id列表
            List<AppEntranceAdRO> appEntranceAdROS = facadeAppEntranceService.findByIds(successIds);
            for (AppEntranceAdRO appEntranceAdRO : appEntranceAdROS) {
                List<String> toList = new ArrayList<>();
                Long providerId = appEntranceAdRO.getProviderId();
                Provider provider = facadeProviderService.findByIdWithNotNull(providerId);
                //ProviderFinance providerFinance = facadeProviderFinanceService.findOneByOneParamWithNotNull(ProviderFinance.COL_PROVIDER_ID, providerId);
                UserRo mjUser = aclUserIntegration.queryUserByUsername(provider.getMjCode());
                log.info("本次查询的媒介code:{}", provider.getMjCode());
                if (mjUser != null) {
                    String mjEmail = mjUser.getEmail();
                    log.info("mjEmail:{}", mjEmail);
                    if (StringUtils.isNotBlank(mjEmail) && RegExpValidatorUtils.isEmail(mjEmail)) {
                        toList.add(mjEmail);//媒介邮箱
                    }
                }
                if (RegExpValidatorUtils.isEmail(provider.getEmail())) {
                    toList.add(provider.getEmail());//开发者邮箱
                }
                if (CollectionUtils.isNotEmpty(toList)) {
                    HashMap<String, Object> kvMap = new HashMap<>();
                    kvMap.put("ask_datetime", DateUtil.dateToFormat(provider.getSubmitReviewDate(), "yyyy-MM-dd HH:mm:ss"));
                    kvMap.put("receiver_name", provider.getProviderName());
                    kvMap.put("login_links", "https://dev.bianxianmao.com/#/login");
                    kvMap.put("perfect_links", "https://dev.bianxianmao.com/#/login");
                    kvMap.put("play_links", "https://dev.bianxianmao.com/#/login");

                    if (!isMJ) {
                        if (auditPass) {
                            //发送通过邮件
                            Constant.pushEmailThreadPool.execute(() -> {
                                try {
                                    mailService.sendRegisterAuditSuccess(toList, "变现猫-广告位信息审核通过！", kvMap);
                                } catch (Exception e) {
                                    log.error("send 广告位信息审核通过邮件失败",e);
                                }
                            });
                        } else {
                            //发送拒绝邮件
                            if (StringUtils.isNotBlank(reviewRefuseIds)) {
                                kvMap.put("reason", reviewRefuseIdsDesc);
                            }
                            Constant.pushEmailThreadPool.execute(() -> {
                                try {
                                    mailService.sendRegisterAuditFail(toList, "变现猫-广告位信息审核失败！", kvMap);
                                } catch (Exception e) {
                                    log.error("send 广告位信息审核失败邮件 error",e);
                                }
                            });
                        }
                    } else if (isMJ && !auditPass) {
                        //发送拒绝邮件
                        kvMap.put("reason", "请联系工作人员。");
                        Constant.pushEmailThreadPool.execute(() -> {
                            try {
                                mailService.sendRegisterAuditFail(toList, "变现猫-广告位信息审核失败！", kvMap);
                            } catch (Exception e) {
                                log.error("send 广告位信息审核失败邮件 error",e);
                            }
                        });
                    }
                }
            }
        }

        return ResultModelFactory.SUCCESS(successIds);
    }

    @Override
    public ResultModel<Boolean> positionSwitch(String positionId, Boolean closeFlag, String modifier) {
        if (StringUtils.isBlank(positionId) || null == closeFlag || StringUtils.isBlank(modifier)) {
            throw new BusinessException("参数不正确！");
        }
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.positionSwitch(positionId, closeFlag, modifier));
    }

    @Override
    public ResultModel<Boolean> updateByPositionId(@RequestBody UpdateAppEntranceDTO dto) {
        if (StringUtils.isBlank(dto.getPositionId())) {
            return ResultModelFactory.FAILED400("positionId 不能为空！");
        }
        if (StringUtils.isBlank(dto.getModifier())) {
            return ResultModelFactory.FAILED400("modifier 不能为空！");
        }
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.updateByPositionId(dto));
    }

    @Override
    public ResultModel<Integer> queryDockMethod(String appKey, String appEntranceId) {
        if (StringUtils.isBlank(appKey) || StringUtils.isBlank(appEntranceId)) {
            return ResultModelFactory.SUCCESS(0);
        }
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.queryDockMethod(appKey, appEntranceId));
    }

    @Override
    public ResultModel<List<String>> getPositionIdsByIds(String ids) {
        if (StringUtils.isBlank(ids)) {
            return ResultModelFactory.SUCCESS(Collections.emptyList());
        }
        List<Long> parse = JSON.parseArray(ids, Long.class);
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.getPositionIdsByIds(parse));
    }

    @Override
    public ResultModel<List<QueryPositionIdAndNameVo>> getPositionIdAndName(String keyWords, String appKey) {
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.getPositionIdAndName(keyWords, appKey));
    }

    @Override
    public ResultModel<List<AppEntranceCountByAppKeyVO>> getAppEntranceCountGroupByAppKeys(@RequestBody String appKeysStr) {
        if (StringUtils.isBlank(appKeysStr)) {
            return ResultModelFactory.SUCCESS(Collections.emptyList());
        }
        List<String> appKeys = Splitter.on(Constant.BaseCharacter.COMMA_EN).omitEmptyStrings().splitToList(appKeysStr);
        if (CollectionUtils.isEmpty(appKeys)) {
            return ResultModelFactory.SUCCESS(Collections.emptyList());
        }
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.getAppEntranceCountGroupByAppKeys(appKeys));
    }

    @Override
    public ResultModel<List<AppEntranceMinOnlineTimeByAppKeyVO>> getAppEntranceMinOnlineTimeGroupByAppKey(@RequestBody QueryAppEntranceByMinOnlineTimeParamDTO paramDTO) {
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.getAppEntranceMinOnlineTimeGroupByAppKey(paramDTO));
    }

    @Override
    public ResultModel<List<AppEntranceAdRO>> getListByPositionIds(@RequestParam(value = "positionIds") String jsonString) {
        if (StringUtils.isBlank(jsonString)) {
            return ResultModelFactory.SUCCESS(Collections.emptyList());
        }
        List<String> positionIds = JSON.parseArray(jsonString, String.class);
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.getListByPositionIds(positionIds));
    }

    @Override
    public ResultModel<List<AppEntranceAdRO>> getPositionList(@RequestBody QueryAppAdPositionDTO dto) {
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.getPositionList(dto));
    }

    @Override
    public ResultModel<List<String>> getAllPositionIds(@RequestBody QueryAppEntranceParamDTO dto) {
        dto.setPageNum(1);
        dto.setPageSize(Integer.MAX_VALUE);
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.getAllPositionIds(dto));

    }

    @Override
    public ResultModel<List<AppEntranceAdRO>> getList(@RequestBody QueryAppEntranceParamDTO dto) {
        dto.setPageNum(1);
        dto.setPageSize(Integer.MAX_VALUE);
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.getPageInFacade(dto).getList());

    }

    @Override
    public ResultModel<Boolean> updateMaterialType(String positionId, String materialType) {
        if (StringUtils.isBlank(positionId) || StringUtils.isBlank(materialType)) {
            throw new BusinessException("参数不正确！");
        }
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.updateMaterialType(positionId, materialType));
    }

    @Override
    public ResultModel<Boolean> updateCouponsInfo(@RequestBody UpdateAppEntranceDTO dto) {
        if (StringUtils.isBlank(dto.getPositionId())) {
            return ResultModelFactory.FAILED400("positionId 不能为空！");
        }
        return ResultModelFactory.SUCCESS(facadeAppEntranceService.updateCouponsInfo(dto));
    }
}
