package com.bxm.adsmedia.web.facade.controller;

import com.bxm.adsmedia.facade.model.article.ArticleDto;
import com.bxm.adsmedia.facade.model.article.ArticleRo;
import com.bxm.adsmedia.facade.service.ArticleFacadeService;
import com.bxm.adsmedia.service.article.facade.FacadeArticleService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Description 广告位facade controller
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/23 17:20
 */
@Slf4j
@RestController
public class ArticleFacadeServiceImpl implements ArticleFacadeService {

    @Autowired
    FacadeArticleService facadeArticleService;

    @Override
    public ResultModel<PageInfo<ArticleRo>> getAppList(Integer pageSize, Integer pageNum) {
        return ResultModelFactory.SUCCESS(facadeArticleService.getAppList(pageSize, pageNum));
    }

    @Override
    public ResultModel<Boolean> addArticle(@RequestBody ArticleDto articleDto) {
        facadeArticleService.addArticle(articleDto);
        return ResultModelFactory.SUCCESS(true);
    }

    @Override
    public ResultModel<Boolean> updateArticle(@RequestBody ArticleDto articleDto) {
        facadeArticleService.updateArticle(articleDto);
        return ResultModelFactory.SUCCESS(true);
    }

    @Override
    public ResultModel<Boolean> deleteArticle(@RequestParam(value = "id") Long id) {
        facadeArticleService.deleteArticle(id);
        return ResultModelFactory.SUCCESS(true);
    }

    @Override
    public ResultModel<Boolean> moveArticle(String id, String type) {
        facadeArticleService.moveArticle(id, type);
        return ResultModelFactory.SUCCESS(true);
    }
}
