package com.bxm.adsmedia.web.facade.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.acl.facade.model.UserRo;
import com.bxm.adsmedia.common.util.DateUtil;
import com.bxm.adsmedia.common.util.RegExpValidatorUtils;
import com.bxm.adsmedia.dal.entity.Media;
import com.bxm.adsmedia.dal.entity.Provider;
import com.bxm.adsmedia.dal.entity.ReviewRefuseConfig;
import com.bxm.adsmedia.dal.mapper.ReviewRefuseConfigMapper;
import com.bxm.adsmedia.facade.model.media.MediaAuditVO;
import com.bxm.adsmedia.facade.service.MediaFacadeService;
import com.bxm.adsmedia.integration.acl.AclUserIntegration;
import com.bxm.adsmedia.model.constant.Constant;
import com.bxm.adsmedia.service.common.MailService;
import com.bxm.adsmedia.service.media.facade.FacadeMediaService;
import com.bxm.adsmedia.service.provider.facade.FacadeProviderFinanceService;
import com.bxm.adsmedia.service.provider.facade.FacadeProviderService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.github.pagehelper.PageInfo;

import lombok.extern.slf4j.Slf4j;

/**
 * Description TODO
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/28 15:03
 */
@Slf4j
@RestController
public class MediaFacadeServiceImpl implements MediaFacadeService {

    @Autowired
    private FacadeMediaService facadeMediaService;
    @Autowired
    private FacadeProviderFinanceService facadeProviderFinanceService;
    @Autowired
    private MailService mailService;
    @Autowired
    private FacadeProviderService facadeProviderService;
    @Autowired
    private ReviewRefuseConfigMapper reviewRefuseConfigMapper;

    @Autowired
    private AclUserIntegration aclUserIntegration;

    @Override
    public ResultModel<PageInfo<MediaAuditVO>> getAuditPage(String companyName, String mediaName, Byte status,Long providerId,
                                                            String mjCode, Integer pageNum, Integer pageSize) {
        return ResultModelFactory.SUCCESS(facadeMediaService.getAuditPage(companyName, mediaName, status,providerId, mjCode, pageNum, pageSize));
    }

    @Override
    public ResultModel<Boolean> audit(Long id, Boolean auditPass, Boolean isMJ, String refuseReason, String reviewRefuseIds, String modifier) {
        String reviewRefuseIdsDesc =StringUtils.EMPTY;
        if(StringUtils.isNotBlank(reviewRefuseIds)){
            List<Long> refuseIds = Arrays.asList(reviewRefuseIds.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List<ReviewRefuseConfig> reviewRefuseConfigList = reviewRefuseConfigMapper.getListByIds(refuseIds);

            if(CollectionUtils.isNotEmpty(reviewRefuseConfigList)){
                StringBuffer refuseReasonStringBuffer = new StringBuffer();
                for (ReviewRefuseConfig reviewRefuseConfig : reviewRefuseConfigList) {
                    refuseReasonStringBuffer.append("<div>").append(reviewRefuseConfig.getMediaShowReason()).append("\t").append(reviewRefuseConfig.getAdvise()).append("</div>");
                }
                reviewRefuseIdsDesc = refuseReasonStringBuffer.toString();
            }
        }

        Boolean audit = facadeMediaService.audit(id, auditPass, isMJ, refuseReason, reviewRefuseIds,
                reviewRefuseIdsDesc.replaceAll("<div>","").replaceAll("</div>",""), modifier);

        log.info("发邮件逻辑开始。");

        if(audit){
            List<String> toList = new ArrayList<>();
            Media media = facadeMediaService.findByIdWithNotNull(id);
            Long providerId = media.getProviderId();
            Provider provider = facadeProviderService.findByIdWithNotNull(providerId);
            //ProviderFinance providerFinance = facadeProviderFinanceService.findOneByOneParamWithNotNull(ProviderFinance.COL_PROVIDER_ID, providerId);
            UserRo mjUser = aclUserIntegration.queryUserByUsername(provider.getMjCode());
            if(mjUser != null){
                String mjEmail = mjUser.getEmail();
                if (StringUtils.isNotBlank(mjEmail) && RegExpValidatorUtils.isEmail(mjEmail)) {
                    toList.add(mjEmail);//媒介邮箱
                }
            }
            if (RegExpValidatorUtils.isEmail(provider.getEmail())) {
                toList.add(provider.getEmail());//开发者邮箱
            }
            if(CollectionUtils.isNotEmpty(toList)){
                HashMap<String, Object> kvMap = new HashMap<>();
                kvMap.put("ask_datetime", DateUtil.dateToFormat(provider.getSubmitReviewDate(), "yyyy-MM-dd HH:mm:ss"));
                kvMap.put("receiver_name", provider.getProviderName());
                kvMap.put("login_links", "https://dev.bianxianmao.com/#/login");
                kvMap.put("perfect_links", "https://dev.bianxianmao.com/#/login");
                kvMap.put("play_links", "https://dev.bianxianmao.com/#/login");

                //风控
                if(!isMJ ){
                    if (auditPass) {
                        log.info("风控审核通过，发送通过邮件。");
                        //发送通过邮件
                        Constant.pushEmailThreadPool.execute(() -> {
                            try {
                                mailService.sendRegisterAuditSuccess(toList, "变现猫-媒体信息审核通过！", kvMap);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    }else{
                        //发送拒绝邮件
                        log.info("风控审核拒绝，发送拒绝邮件。");
                        if(StringUtils.isNotBlank(reviewRefuseIds)){
                            kvMap.put("reason", reviewRefuseIdsDesc);
                        }
                        Constant.pushEmailThreadPool.execute(() -> {
                            try {
                                mailService.sendRegisterAuditFail(toList, "变现猫-媒体信息审核失败！", kvMap);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    }
                }else if(isMJ && !auditPass){
                    log.info("是媒介，发送拒绝邮件。");
                    kvMap.put("reason", "请联系工作人员。");
                    Constant.pushEmailThreadPool.execute(() -> {
                        try {
                            mailService.sendRegisterAuditFail(toList, "变现猫-媒体信息审核失败！", kvMap);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
            }
        }
        return ResultModelFactory.SUCCESS(audit);
    }

    @Override
    public ResultModel<Boolean> updateTags(Long id, String tags, String modifier) {
        return ResultModelFactory.SUCCESS(facadeMediaService.updateTags(id, tags, modifier));
    }
}
