package com.bxm.adsmedia.web.facade.controller;

import com.bxm.adsmedia.facade.model.positionclasstype.PositionClassTypeDto;
import com.bxm.adsmedia.facade.model.positionclasstype.PositionClassTypeRo;
import com.bxm.adsmedia.facade.service.PositionClassTypeFacadeService;
import com.bxm.adsmedia.service.media.facade.FacadePositionClassTypeService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author 拉拉
 * @fileName com.bxm.adsmedia.web.facade.controller.PositionClassTypeFacadeServiceImpl.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2019-01-28 10:17:00
 * @modifier 拉拉
 * @updated 2019-01-28 10:17:00
 */
@Slf4j
@RestController
public class PositionClassTypeFacadeServiceImpl implements PositionClassTypeFacadeService {


    @Autowired
    FacadePositionClassTypeService facadePositionClassTypeService;

    @Override
    public ResultModel<List<PositionClassTypeRo>> queryPositionClassTypeList(@RequestBody PositionClassTypeDto positionClassTypeDto) {
        ResultModel<List<PositionClassTypeRo>> resultModel = new ResultModel<List<PositionClassTypeRo>>();
        List<PositionClassTypeRo> list = null;
        if (null == positionClassTypeDto) {
            positionClassTypeDto = new PositionClassTypeDto();
        }
        list = facadePositionClassTypeService.queryPositionClassTypeList(positionClassTypeDto);
        resultModel.setReturnValue(list);
        return resultModel;
    }

    @Override
    public ResultModel<PageInfo<PositionClassTypeRo>> queryPositionClassTypePageList(@RequestBody PositionClassTypeDto positionClassTypeDto) {
        ResultModel<PageInfo<PositionClassTypeRo>> resultModel = new ResultModel<PageInfo<PositionClassTypeRo>>();
        PageInfo<PositionClassTypeRo> pageInfo = null;
        if (null == positionClassTypeDto) {
            positionClassTypeDto = new PositionClassTypeDto();
        }
        pageInfo = facadePositionClassTypeService.queryPositionClassTypePageList(positionClassTypeDto);
        resultModel.setReturnValue(pageInfo);
        return resultModel;
    }

    @Override
    public ResultModel<PositionClassTypeRo> getPositionClassTypeById(Long id) {
        ResultModel<PositionClassTypeRo> resultModel = new ResultModel<>();
        resultModel.setReturnValue(facadePositionClassTypeService.queryPositionClassTypeById(id));
        return resultModel;
    }

    @Override
    public ResultModel<Boolean> updatePositionClassTypeById(@RequestBody PositionClassTypeRo positionClassType) {
        ResultModel<Boolean> resultModel = new ResultModel<>();
        if (null == positionClassType || positionClassType.getId() == null) {
            return ResultModelFactory.FAILED400("ID不能为空");
        }
        facadePositionClassTypeService.updatePositionClassTypeById(positionClassType);
        resultModel.setReturnValue(true);
        return resultModel;
    }

    @Override
    public ResultModel<Boolean> addPositionClassType(@RequestBody PositionClassTypeRo positionClassType) {
        ResultModel<Boolean> resultModel = new ResultModel<>();
        if (null == positionClassType || positionClassType.getParentId() == null) {
            return ResultModelFactory.FAILED400("parentId不能为空");
        }
        if (StringUtils.isBlank(positionClassType.getTypeCode())) {
            return ResultModelFactory.FAILED400("typeCode不能为空");
        }
        if (StringUtils.isBlank(positionClassType.getName())) {
            return ResultModelFactory.FAILED400("name不能为空");
        }

        //查询一级分类是否存在
        Long count = 0L;
        if (positionClassType.getParentId() == 0) {
            PositionClassTypeDto positionClassTypeDto = new PositionClassTypeDto();
            positionClassTypeDto.setParentId(0L);
            positionClassTypeDto.setTypeCode(positionClassType.getTypeCode());
            positionClassTypeDto.setName(positionClassType.getName());
            count = facadePositionClassTypeService.selectClassNameIsExist(positionClassTypeDto);
            if (count != 0) {
                return ResultModelFactory.FAILED400("一级分类名不允许重复");
            }
        }
        facadePositionClassTypeService.addPositionClassType(positionClassType);
        resultModel.setReturnValue(true);
        return resultModel;
    }

    @Override
    public ResultModel<Boolean> delPositionClassTypeById(Long id, String typeCode) {
        ResultModel<Boolean> resultModel = new ResultModel<>();
        facadePositionClassTypeService.deletePositionClassTypeById(id, typeCode);
        resultModel.setReturnValue(true);
        return resultModel;
    }
}
