package com.bxm.adsmedia.web.facade.controller;

import com.bxm.adsmedia.common.exception.BusinessException;
import com.bxm.adsmedia.facade.model.provider.*;
import com.bxm.adsmedia.facade.service.ProviderFacadeService;
import com.bxm.adsmedia.service.provider.ProviderFinanceService;
import com.bxm.adsmedia.service.provider.facade.FacadeProviderService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Description 开发者相关接口
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/23 19:27
 */
@Slf4j
@RestController
public class ProviderFacadeServiceImpl implements ProviderFacadeService {

    @Autowired
    private FacadeProviderService facadeProviderService;
    @Autowired
    private ProviderFinanceService providerFinanceService;

    @Override
    public ResultModel<PageInfo<ProviderRO>> getPage(@RequestBody QueryProviderParamsDTO dto) {
        return ResultModelFactory.SUCCESS(facadeProviderService.getPage(dto));
    }

    @Override
    public ResultModel<Boolean> update(@RequestBody UpdateProviderAppParamDTO dto) {
        if (StringUtils.isBlank(dto.getAppKey())) {
            throw new BusinessException("AppKey 不允许为空！");
        }
        return ResultModelFactory.SUCCESS(facadeProviderService.update(dto));
    }

    @Override
    public ResultModel<List<ProviderAppAdRO>> getAppList(@RequestBody  ProviderAppAdDTO providerAppAdDto) {
        return ResultModelFactory.SUCCESS(facadeProviderService.getAppList(providerAppAdDto));
    }

    @Override
    public ResultModel<List<String>> getAppKeyList(@RequestBody ProviderAppAdDTO providerAppAdDto) {
        return ResultModelFactory.SUCCESS(facadeProviderService.getAppKeyList(providerAppAdDto));
    }

    @Override
    public ResultModel<ProviderAppAdRO> getAppInfoByAppKey(String appKey) {
        return ResultModelFactory.SUCCESS(facadeProviderService.getAppInfoByAppKey(appKey));
    }

    @Override
    public ResultModel<List<ProviderAppAdRO>> getList(String keywords) {
        return ResultModelFactory.SUCCESS(facadeProviderService.getList(keywords));
    }

    @Override
    public ResultModel<List<ProviderAppAdRO>> getListByAdvanceType(Integer advanceType, String keywords) {
        return ResultModelFactory.SUCCESS(facadeProviderService.getListByAdvanceType(advanceType,keywords));
    }

    @Override
    public ResultModel<Boolean> setMj(Long providerId, String mjCode, String modifier) {
        if (null == providerId || StringUtils.isBlank(mjCode) || StringUtils.isBlank(modifier)) {
            throw new BusinessException("请检查参数！");
        }
        return ResultModelFactory.SUCCESS(facadeProviderService.setMj(providerId, mjCode, modifier));
    }

    @Override
    public ResultModel<Boolean> updateBasic(Long providerId, String mjCode, String bdCode, String tags, String modifier) {
       //数据check
        if (null == providerId|| StringUtils.isBlank(modifier)) {
            throw new BusinessException("请检查参数！");
        }
        if (StringUtils.isBlank(mjCode)&&StringUtils.isBlank(bdCode)&&tags==null) {
            throw new BusinessException("请选择需要修改的数据！");
        }
        return ResultModelFactory.SUCCESS(facadeProviderService.updateBasic(providerId, mjCode, bdCode, tags, modifier));
    }


}
