package com.bxm.adsmedia.web.facade.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

import com.bxm.adsmedia.dal.entity.Media;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.provider.FirstProviderAuditDto;
import com.bxm.adsmedia.service.media.facade.FacadeAppEntranceService;
import com.bxm.adsmedia.service.media.facade.FacadeMediaService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.acl.facade.model.UserRo;
import com.bxm.adsmedia.common.util.DateUtil;
import com.bxm.adsmedia.common.util.RegExpValidatorUtils;
import com.bxm.adsmedia.dal.entity.Provider;
import com.bxm.adsmedia.dal.entity.ProviderFinance;
import com.bxm.adsmedia.dal.entity.ReviewRefuseConfig;
import com.bxm.adsmedia.dal.mapper.ReviewRefuseConfigMapper;
import com.bxm.adsmedia.facade.model.provider.ProviderFinanceListRO;
import com.bxm.adsmedia.facade.model.provider.ProviderStatusListRO;
import com.bxm.adsmedia.facade.service.ProviderFinanceFacadeService;
import com.bxm.adsmedia.integration.acl.AclUserIntegration;
import com.bxm.adsmedia.model.constant.Constant;
import com.bxm.adsmedia.service.common.MailService;
import com.bxm.adsmedia.service.provider.facade.FacadeProviderFinanceService;
import com.bxm.adsmedia.service.provider.facade.FacadeProviderService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.github.pagehelper.PageInfo;

import lombok.extern.slf4j.Slf4j;

/**
 * Description 开发者相关接口
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/23 19:27
 */
@Slf4j
@RestController
public class ProviderFinanceFacadeServiceImpl implements ProviderFinanceFacadeService {

    @Autowired
    private FacadeProviderFinanceService facadeProviderFinanceService;
    @Autowired
    private MailService mailService;
    @Autowired
    private FacadeProviderService facadeProviderService;
    @Autowired
    private ReviewRefuseConfigMapper reviewRefuseConfigMapper;
    @Autowired
    private AclUserIntegration aclUserIntegration;
    @Autowired
    private FacadeMediaService facadeMediaService;
    @Autowired
    private FacadeAppEntranceService facadeAppEntranceService;

    @Override
    public ResultModel<PageInfo<ProviderFinanceListRO>> getAuditPage(String keywords, String mjCode, long providerId,Byte status, Integer pageNum, Integer pageSize) {
        pageNum = pageNum == null ? 1 : pageNum;
        pageSize = pageSize == null ? 15 : pageSize;
        return ResultModelFactory.SUCCESS(facadeProviderFinanceService.getAuditPage(keywords, mjCode,providerId, status, pageNum, pageSize));
    }

    @Override
    public ResultModel<PageInfo<ProviderStatusListRO>> getAuditStatusPage(String providerName, String email,
                                                                          Byte financeStatus, Byte mediaStatus,
                                                                          Byte appEntranceStatus, String mjCode,  String bdCode,
                                                                          Boolean isOrderByDateDesc, String code, Integer pageNum,
                                                                          Integer pageSize) {
        pageNum = pageNum == null ? 1 : pageNum;
        pageSize = pageSize == null ? 15 : pageSize;
        return ResultModelFactory.SUCCESS(facadeProviderFinanceService.getAuditStatusPage(providerName, email, financeStatus, mediaStatus, appEntranceStatus, mjCode, bdCode,isOrderByDateDesc, code, pageNum, pageSize));
    }

    @Override
    public ResultModel<Boolean> audit(Long providerId, Boolean auditPass, String refuseReason, String reviewRefuseIds, String modifier, boolean isRiskController) {
        if (null == providerId || null == auditPass || StringUtils.isBlank(modifier)) {
            return ResultModelFactory.FAILED400("参数不正确！");
        }
        if (refuseReason == null) {
            refuseReason = StringUtils.EMPTY;
        }
        // 暂定拒绝原因可为空
        Boolean audit = facadeProviderFinanceService.audit(providerId, auditPass, refuseReason, reviewRefuseIds,
                modifier, isRiskController);

        if (audit) {
            sendFinanceMail(providerId, isRiskController, auditPass);
        }
        return ResultModelFactory.SUCCESS(audit);
    }

    @Override
    public ResultModel<FirstProviderAuditDto> firstAudit(Long providerId, Boolean auditPass, String modifier, boolean isRiskController) {
        if (null == providerId || null == auditPass || StringUtils.isBlank(modifier)) {
            return ResultModelFactory.FAILED400("参数不正确！");
        }

        FirstProviderAuditDto firstProviderAuditDto = facadeProviderFinanceService.firstAudit(providerId, auditPass, modifier, isRiskController);
        if (!isRiskController && firstProviderAuditDto.getResult()) {
            List<String> toList = new ArrayList<>();
            Provider provider = facadeProviderService.findByIdWithNotNull(providerId);
            UserRo mjUser = aclUserIntegration.queryUserByUsername(provider.getMjCode());
            if (mjUser != null) {
                String mjEmail = mjUser.getEmail();
                if (StringUtils.isNotBlank(mjEmail) && RegExpValidatorUtils.isEmail(mjEmail)) {
                    toList.add(mjEmail);//媒介邮箱
                }
            }
            if (RegExpValidatorUtils.isEmail(provider.getEmail())) {
                toList.add(provider.getEmail());//开发者邮箱
            }
            if (CollectionUtils.isNotEmpty(toList)) {
                HashMap<String, Object> kvMap = new HashMap<>();
                kvMap.put("ask_datetime", DateUtil.dateToFormat(provider.getSubmitReviewDate(), "yyyy-MM-dd HH:mm:ss"));
                kvMap.put("receiver_name", provider.getProviderName());
                kvMap.put("login_links", "https://dev.bianxianmao.com/#/login");
                kvMap.put("perfect_links", "https://dev.bianxianmao.com/#/login");
                kvMap.put("play_links", "https://dev.bianxianmao.com/#/login");

                if (!auditPass) {
                    //发送拒绝邮件
                    kvMap.put("reason", "请联系工作人员。");
                    Constant.pushEmailThreadPool.execute(() -> {
                        try {
                            mailService.sendRegisterAuditFail(toList, "变现猫-媒体信息审核失败！", kvMap);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }

            }
        }
        //风控
        if (isRiskController) {
            //财务终审通过或失败
            if (firstProviderAuditDto.getProviderFinanceStatus()) {
                sendFinanceMail(providerId, isRiskController, auditPass);
            }
            //媒体终审通过或者失败
            sendMedialMail(firstProviderAuditDto.getMediaSuccessIds(), auditPass, StringUtils.EMPTY);
            //广告位终审通过或失败
            sendAppEntranceMail(firstProviderAuditDto.getAppEntranceSuccessIds(), auditPass, StringUtils.EMPTY, StringUtils.EMPTY);
        }
        return ResultModelFactory.SUCCESS(firstProviderAuditDto);
    }



    private void sendMedialMail(List<Long> ids, boolean auditPass, String reviewRefuseIds) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        for (Long id : ids) {
            log.info("发邮件逻辑开始。");
            if (auditPass) {
                List<String> toList = new ArrayList<>();
                Media media = facadeMediaService.findByIdWithNotNull(id);
                Long providerId = media.getProviderId();
                Provider provider = facadeProviderService.findByIdWithNotNull(providerId);
                //ProviderFinance providerFinance = facadeProviderFinanceService.findOneByOneParamWithNotNull(ProviderFinance.COL_PROVIDER_ID, providerId);
                UserRo mjUser = aclUserIntegration.queryUserByUsername(provider.getMjCode());
                if (mjUser != null) {
                    String mjEmail = mjUser.getEmail();
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(mjEmail) && RegExpValidatorUtils.isEmail(mjEmail)) {
                        toList.add(mjEmail);//媒介邮箱
                    }
                }
                if (RegExpValidatorUtils.isEmail(provider.getEmail())) {
                    toList.add(provider.getEmail());//开发者邮箱
                }
                if (CollectionUtils.isNotEmpty(toList)) {
                    HashMap<String, Object> kvMap = new HashMap<>();
                    kvMap.put("ask_datetime", DateUtil.dateToFormat(provider.getSubmitReviewDate(), "yyyy-MM-dd HH:mm:ss"));
                    kvMap.put("receiver_name", provider.getProviderName());
                    kvMap.put("login_links", "https://dev.bianxianmao.com/#/login");
                    kvMap.put("perfect_links", "https://dev.bianxianmao.com/#/login");
                    kvMap.put("play_links", "https://dev.bianxianmao.com/#/login");

                    if (auditPass) {
                        log.info("风控终审通过，发送通过邮件。");
                        //发送通过邮件
                        Constant.pushEmailThreadPool.execute(() -> {
                            try {
                                mailService.sendRegisterAuditSuccess(toList, "变现猫-媒体信息审核通过！", kvMap);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    } else {
                        //发送拒绝邮件
                        log.info("风控终审拒绝，发送拒绝邮件。");
                        if (org.apache.commons.lang3.StringUtils.isNotBlank(reviewRefuseIds)) {
                            kvMap.put("reason", StringUtils.EMPTY);
                        }
                        Constant.pushEmailThreadPool.execute(() -> {
                            try {
                                mailService.sendRegisterAuditFail(toList, "变现猫-媒体信息审核失败！", kvMap);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    }
                }
            }
        }
    }

    /**
     * 发送财务邮件通知
     *
     * @param providerId
     * @param isRiskController
     * @param auditPass
     */
    public void sendFinanceMail(Long providerId, boolean isRiskController, boolean auditPass) {
        List<String> toList = new ArrayList<>();
        Provider provider = facadeProviderService.findByIdWithNotNull(providerId);
        ProviderFinance providerFinance = facadeProviderFinanceService.findOneByOneParamWithNotNull(ProviderFinance.COL_PROVIDER_ID, providerId);
        UserRo mjUser = aclUserIntegration.queryUserByUsername(provider.getMjCode());
        if (mjUser != null) {
            String mjEmail = mjUser.getEmail();
            if (StringUtils.isNotBlank(mjEmail) && RegExpValidatorUtils.isEmail(mjEmail)) {
                toList.add(mjEmail);//媒介邮箱
            }
        }
        if (RegExpValidatorUtils.isEmail(provider.getEmail())) {
            toList.add(provider.getEmail());//开发者邮箱
        }
        if (CollectionUtils.isNotEmpty(toList)) {
            HashMap<String, Object> kvMap = new HashMap<>();
            kvMap.put("ask_datetime", DateUtil.dateToFormat(provider.getSubmitReviewDate(), "yyyy-MM-dd HH:mm:ss"));
            kvMap.put("receiver_name", provider.getProviderName());
            kvMap.put("login_links", "https://dev.bianxianmao.com/#/login");
            kvMap.put("perfect_links", "https://dev.bianxianmao.com/#/login");
            kvMap.put("play_links", "https://dev.bianxianmao.com/#/login");

            if (isRiskController && auditPass) {
                //发送通过邮件
                Constant.pushEmailThreadPool.execute(() -> {
                    try {
                        mailService.sendRegisterAuditSuccess(toList, "变现猫-财务信息审核通过！", kvMap);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            } else if (!auditPass) {
                //发送拒绝邮件
                List<ReviewRefuseConfig> reviewRefuseConfigList = null;
                if (StringUtils.isNotBlank(providerFinance.getReviewRefuseIds())) {
                    List<Long> refuseIds = Arrays.asList(providerFinance
                            .getReviewRefuseIds().split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    reviewRefuseConfigList = reviewRefuseConfigMapper.getListByIds(refuseIds);
                }

                String reason = "";
                if (CollectionUtils.isNotEmpty(reviewRefuseConfigList)) {
                    StringBuffer refuseReasonStringBuffer = new StringBuffer();
                    for (ReviewRefuseConfig reviewRefuseConfig : reviewRefuseConfigList) {
                        refuseReasonStringBuffer.append("<div>").append(reviewRefuseConfig.getMediaShowReason()).append("\t").append(reviewRefuseConfig.getAdvise()).append("</div>");
                    }
                    reason = refuseReasonStringBuffer.toString();
                }
                kvMap.put("reason", reason);
                Constant.pushEmailThreadPool.execute(() -> {
                    try {
                        mailService.sendRegisterAuditFailForFinance(toList, "变现猫-财务信息审核失败！", kvMap);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }

    /**
     * 发送广告位审核邮件
     *
     * @param ids
     * @param auditPass
     * @param reviewRefuseIds
     * @param reviewRefuseIdsDesc
     */
    private void sendAppEntranceMail(List<Long> ids, boolean auditPass, String reviewRefuseIds, String reviewRefuseIdsDesc) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        List<AppEntranceAdRO> appEntranceAdROS = facadeAppEntranceService.findByIds(ids);
        for (AppEntranceAdRO appEntranceAdRO : appEntranceAdROS) {
            List<String> toList = new ArrayList<>();
            Long providerId = appEntranceAdRO.getProviderId();
            Provider provider = facadeProviderService.findByIdWithNotNull(providerId);
            UserRo mjUser = aclUserIntegration.queryUserByUsername(provider.getMjCode());
            log.info("本次查询的媒介code:{}", provider.getMjCode());
            if (mjUser != null) {
                String mjEmail = mjUser.getEmail();
                log.info("mjEmail:{}", mjEmail);
                if (StringUtils.isNotBlank(mjEmail) && RegExpValidatorUtils.isEmail(mjEmail)) {
                    toList.add(mjEmail);//媒介邮箱
                }
            }
            if (RegExpValidatorUtils.isEmail(provider.getEmail())) {
                toList.add(provider.getEmail());//开发者邮箱
            }
            if (CollectionUtils.isNotEmpty(toList)) {
                HashMap<String, Object> kvMap = new HashMap<>();
                kvMap.put("ask_datetime", DateUtil.dateToFormat(provider.getSubmitReviewDate(), "yyyy-MM-dd HH:mm:ss"));
                kvMap.put("receiver_name", provider.getProviderName());
                kvMap.put("login_links", "https://dev.bianxianmao.com/#/login");
                kvMap.put("perfect_links", "https://dev.bianxianmao.com/#/login");
                kvMap.put("play_links", "https://dev.bianxianmao.com/#/login");

                if (auditPass) {
                    //发送通过邮件
                    Constant.pushEmailThreadPool.execute(() -> {
                        try {
                            mailService.sendRegisterAuditSuccess(toList, "变现猫-广告位信息审核通过！", kvMap);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                } else {
                    //发送拒绝邮件
                    if (StringUtils.isNotBlank(reviewRefuseIds)) {
                        if (StringUtils.isBlank(reviewRefuseIdsDesc)) {
                            kvMap.put("reason", reviewRefuseIdsDesc);
                        }
                    }
                    Constant.pushEmailThreadPool.execute(() -> {
                        try {
                            mailService.sendRegisterAuditFail(toList, "变现猫-广告位信息审核失败！", kvMap);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
            }
        }
    }

}
