package com.bxm.adsmedia.web.facade.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmedia.facade.model.reviewrefuseconfig.ReviewRefuseConfigDTO;
import com.bxm.adsmedia.facade.model.reviewrefuseconfig.ReviewRefuseConfigRO;
import com.bxm.adsmedia.facade.service.ReviewRefuseConfigFacadeService;
import com.bxm.adsmedia.service.reviewrefuesconfig.facade.FacadeReviewRefuseConfigService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.github.pagehelper.PageInfo;

import lombok.extern.slf4j.Slf4j;

/**
 * Description 广告位facade controller
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/23 17:20
 */
@Slf4j
@RestController
public class ReviewRefuseConfigFacadeServiceImpl implements ReviewRefuseConfigFacadeService {

    @Autowired
    private FacadeReviewRefuseConfigService facadeReviewRefuseConfigService;

    @Override
    public ResultModel<PageInfo<ReviewRefuseConfigRO>> getPage(@RequestBody ReviewRefuseConfigDTO dto) {
        return ResultModelFactory.SUCCESS(facadeReviewRefuseConfigService.getPage(dto));
    }

    @Override
    public ResultModel<Boolean> addReviewRefuseConfig(@RequestBody ReviewRefuseConfigDTO reviewRefuseConfigDTO) {
        facadeReviewRefuseConfigService.addReviewRefuseConfig(reviewRefuseConfigDTO);
        return ResultModelFactory.SUCCESS(true);
    }

    @Override
    public ResultModel<Boolean> updateReviewRefuseConfig(@RequestBody ReviewRefuseConfigDTO reviewRefuseConfigDTO) {
        facadeReviewRefuseConfigService.updateReviewRefuseConfig(reviewRefuseConfigDTO);
        return ResultModelFactory.SUCCESS(true);
    }

    @Override
    public ResultModel<Boolean> updateStatus(Long id, Boolean deletedFlag) {
        facadeReviewRefuseConfigService.updateStatus(id, deletedFlag);
        return ResultModelFactory.SUCCESS(true);
    }
}
