package com.bxm.adsmedia.web.facade.controller;

import com.bxm.adsmedia.common.exception.BusinessException;
import com.bxm.adsmedia.facade.service.StationMsgFacadeService;
import com.bxm.adsmedia.service.stationMsg.facade.FacadeStationMsgService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * Description TODO
 *
 * @author hxpeng
 * <p>
 * Date 2019/2/19 11:20
 */
@Slf4j
@RestController
public class StationMsgFacadeServiceImpl implements StationMsgFacadeService {

    @Autowired
    private FacadeStationMsgService facadeStationMsgService;


    @Override
    public ResultModel<Boolean> send(String sender, Long receiverId, String subject, String context) {
        if (StringUtils.isBlank(sender) || null == receiverId || StringUtils.isBlank(subject) || StringUtils.isBlank(context)) {
            throw new BusinessException("请检查参数！");
        }
        return ResultModelFactory.SUCCESS(facadeStationMsgService.send(sender, receiverId, subject, context));
    }
}
