package com.bxm.adsmedia.web.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmedia.common.context.user.UserSessionContext;
import com.bxm.adsmedia.common.entity.User;
import com.bxm.adsmedia.common.util.WebUtil;
import com.bxm.adsmedia.service.common.CommonService;
import com.bxm.warcar.utils.response.ResultModelFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Description 权限拦截
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/15 20:45
 */
@Slf4j
@Component
public class AuthInterceptor implements HandlerInterceptor {

    @Autowired
    private CommonService commonService;

    @Override
    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        UserSessionContext.remove();
        String token = request.getHeader("token");
        if (StringUtils.isBlank(token)) {
            token = request.getParameter("token");
            if (StringUtils.isBlank(token)) {
                noAuthorityAction(response);
                return false;
            }
        }
        User user = commonService.getUserByToken(token);
        if (null == user) {
            noAuthorityAction(response);
            return false;
        }
        UserSessionContext.setContext(user);
        //开始记录全局日志
        log.info(user.getCompanyName() + "\t" + user.getProviderName() + "\t" + user.getAppKey() + "\t" + WebUtil.getIpAddr(request) + "\t" + request.getRequestURL());
        return true;
    }

    @Override
    public void postHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        try {
            commonService.expireUserToken();
        } catch (Exception e) {
            log.error("expire user token fail ！", e);
        } finally {
            UserSessionContext.remove();
        }
    }


    /**
     * Description: 没有权限，打印给前台
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/15 21:32
     *
     * @param response response
     * @return void
     * @author hxpeng
     */
    private static void noAuthorityAction(HttpServletResponse response) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.print(JSONObject.toJSON(ResultModelFactory.FAILED("401", "未登录")));
        out.flush();
    }

}
