package com.bxm.adsmedia.web.interceptor;

import com.bxm.adsmedia.common.context.user.RequestInfoContext;
import com.bxm.adsmedia.common.entity.RequestInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Description 基础拦截器， 用于打印日志， 封装ThreadLocal之类的动作
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/16 15:32
 */
@Slf4j
public class BaseInterceptor implements HandlerInterceptor {

    @Override
    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        //log.info("start================================={}！", request.getRequestURL());
        RequestInfoContext.setContext(new RequestInfo(request, response));
        return true;
    }

    @Override
    public void postHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, ModelAndView modelAndView) throws Exception {
    }

    @Override
    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        //log.info("================================={}===end！", request.getRequestURL());
        RequestInfoContext.remove();
    }


}
