package com.bxm.adsmedia.web.interceptor;

import java.util.List;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

import com.google.common.collect.Lists;

/**
 * Description TODO
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/15 20:41
 */
@Configuration
public class InterceptorConfigurer extends WebMvcConfigurationSupport {

    @Bean
    public AuthInterceptor authInterceptor() {
        return new AuthInterceptor();
    }

    @Bean
    public BaseInterceptor baseInterceptor() {
        return new BaseInterceptor();
    }

    /**
     * 过滤的路径
     */
    private static final List<String> EXCLUDE_PATH_SET = Lists.newArrayList(
            // 一些非业务接口：
            // 短信验证
            "/captcha/img/get",

            // 开发者登录/注册/修改密码/判断邮箱手机号什么的是否存在
            "/provider/login",
            "/provider/register/smsCaptcha",
            "/provider/register",
            "/provider/forgetPwd/smsCaptcha",
            "/provider/forgetPwd",
            "/provider/checkEmailExist",
            "/provider/checkPhoneNumExist",

            //导出接口
            "/test/**",


            // facade接口全过滤
            "/facade/**",
            //api接口过滤
            "/ad/getAppEntranceIncome",
            "/common/**"
    );


    @Override
    protected void addInterceptors(@NonNull InterceptorRegistry registry) {
        registry.addInterceptor(baseInterceptor());
        registry.addInterceptor(authInterceptor()).excludePathPatterns(EXCLUDE_PATH_SET);
        super.addInterceptors(registry);
    }


}
