/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmedia.common.context.user;

import com.bxm.adsmedia.common.entity.User;
import com.bxm.adsmedia.common.exception.AuthException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSessionContext {
    private static final Logger log = LoggerFactory.getLogger(UserSessionContext.class);
    private static final ThreadLocal<User> CONTEXT = new ThreadLocal();

    public static void setContext(User user) {
        CONTEXT.set(user);
    }

    public static void remove() {
        CONTEXT.remove();
    }

    public static User get() {
        return CONTEXT.get();
    }

    private static User getCurrentUser() {
        User user = CONTEXT.get();
        if (null == user) {
            log.warn("\u68c0\u67e5\u4e0b\u6743\u9650 --> ");
            throw new AuthException();
        }
        return user;
    }

    public static Long getProviderId() {
        return UserSessionContext.getCurrentUser().getId();
    }

    public static String getPhoneNum() {
        return UserSessionContext.getCurrentUser().getPhoneNum();
    }

    public static String getToken() {
        return UserSessionContext.getCurrentUser().getToken();
    }

    public static String getProviderName() {
        return UserSessionContext.getCurrentUser().getProviderName();
    }

    public static Boolean hasLogged() {
        return null != UserSessionContext.get();
    }

    public static String getAppKey() {
        return UserSessionContext.getCurrentUser().getAppKey();
    }
}

