package com.bxm.adsprod.convert.media;

import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.media.PositionOfRules;
import com.bxm.adsprod.model.dao.media.PositionDao;
import com.bxm.warcar.utils.Constants;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.base.Preconditions;

/**
 * <h3></h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/28
 */
public final class PositionConvert {

    private PositionConvert() {}

    public static Position of(PositionOfRules orig) {
        Preconditions.checkNotNull(orig);
        Position dest = new Position();
        dest.setId(orig.getId());
        dest.setMediaId(orig.getMediaId());
        dest.setName(orig.getName());
        dest.setDomainCode(orig.getDomainCode());
        dest.setStatus(orig.getStatus());
        dest.setIsCheck(orig.getIsCheck());
        return dest;
    }

    public static Position of(PositionDao orig) {
        Preconditions.checkNotNull(orig);
        Position dest = new Position();
        dest.setId(orig.getPositionId());
        dest.setMediaId(TypeHelper.castToBigInteger(orig.getMediaId()));
        dest.setName(orig.getPositionName());
        dest.setDomainCode(orig.getDomainCode());
        dest.setStatus(Constants.YES);
        dest.setIsCheck(Constants.NO);
        return dest;
    }
}
