package com.bxm.adsprod.convert.media;

import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.media.PositionOfRules;
import com.bxm.adsprod.model.dao.media.PositionDao;
import com.bxm.warcar.utils.Constants;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.base.Preconditions;

/**
 * <h3></h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/28
 */
public final class PositionConvert {

    private PositionConvert() {}

    public static Position of(PositionOfRules orig) {
        Preconditions.checkNotNull(orig);
        Position dest = new Position();
        dest.setId(orig.getId());
        dest.setMediaId(orig.getMediaId());
        dest.setName(orig.getName());
        dest.setDomainCode(orig.getDomainCode());
        dest.setStatus(orig.getStatus());
        dest.setIsCheck(orig.getIsCheck());
        dest.setMediaClassId(orig.getMediaClassId());
        dest.setMediaChildClassId(orig.getMediaChildClassId());
        dest.setMediaSysType(orig.getMediaSysType());
        dest.setPositionEntrance(orig.getPositionEntrance());
        dest.setPositionScene(orig.getPositionScene());
        return dest;
    }

    public static Position of(PositionDao orig) {
        Preconditions.checkNotNull(orig);
        Position dest = new Position();
        dest.setId(orig.getPositionId());
        dest.setMediaId(TypeHelper.castToBigInteger(orig.getMediaId()));
        dest.setName(orig.getPositionName());
        dest.setDomainCode(orig.getDomainCode());
        dest.setStatus(Constants.YES);
        dest.setIsCheck(Constants.NO);
        dest.setMediaClassId(orig.getMediaClassId());
        dest.setMediaChildClassId(orig.getMediaChildClassId());
        dest.setMediaSysType(orig.getMediaSysType());
        dest.setPositionEntrance(orig.getPositionEntrance());
        dest.setProviderId(orig.getProviderId());
        dest.setCouponsIconSize(orig.getCouponsIconSize());
        dest.setCouponsCreativeSize(orig.getCouponsCreativeSize());
        dest.setPutinType(orig.getPutinType());
        dest.setReportUrl(orig.getReportUrl());
        dest.setPositionAdx(orig.getPositionAdx());
        dest.setInspireVideoConfigs(orig.getInspireVideoConfigs());
        dest.setPositionScene(orig.getPositionScene());
        return dest;
    }
}
