package com.bxm.adsprod.counter.event;

import com.bxm.adsprod.facade.ticket.Ticket;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.util.EventObject;

/**
 * <p>时间段预算不足</p>
 * @author allen
 * @since 1.0.0
 */
public class BudgetNotEnoughOfHourlyEvent extends EventObject {


    private final Ticket ticket;
    /**
     * 触发预算不足的时间（hour）
     */
    private final int trigger;
    /**
     * 所在规则的时段开始时间
     */
    private final int segmentStart;
    /**
     * 所在规则的时段结束时间
     */
    private final int segmentEnd;

    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @throws IllegalArgumentException if source is null.
     */
    public BudgetNotEnoughOfHourlyEvent(Object source, Ticket ticket,
                                        int trigger, int segmentStart, int segmentEnd) {
        super(source);
        this.ticket = ticket;
        this.trigger = trigger;
        this.segmentStart = segmentStart;
        this.segmentEnd = segmentEnd;
    }

    public Ticket getTicket() {
        return ticket;
    }

    public int getTrigger() {
        return trigger;
    }

    public int getSegmentStart() {
        return segmentStart;
    }

    public int getSegmentEnd() {
        return segmentEnd;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
