package com.bxm.adsprod.counter.event.listeners;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.common.eventbus.EventListener;
import com.bxm.adsprod.counter.event.BudgetNotEnoughOfDailyEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.google.common.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>日预算不足事件</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/19
 */
@Component
public class BudgetNotEnoughOfDailyEventListener implements EventListener<BudgetNotEnoughOfDailyEvent> {

    private static final Logger LOGGER = LoggerFactory.getLogger(BudgetNotEnoughOfDailyEventListener.class);

    @Reference(version = "1.0.0")
    private TicketService ticketService;

    @Override
    @Subscribe
    public void consume(BudgetNotEnoughOfDailyEvent event) {
        Ticket ticket = event.getTicket();
        if (!ticket.isAvailableForStatus()) {
            return;
        }

        BigInteger id = ticket.getId();

        boolean flag = ticketService.updateTicketStatus(id, Ticket.STATUS_PAUSE, Ticket.PAUSE_REASON_OUT_OF_DAILYBUDGET);

        if (flag) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("广告券({})状态(暂停-日预算不足)更新完成", id);
            }
        }
        else {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("广告券({})状态(暂停-日预算不足)更新失败!", id);
            }
        }
    }
}
